/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.util.concurrent.Callable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.test.subprocess.SubProcess;

class SubProcessTest {
    private static final String MESSAGE = "message";

    SubProcessTest() {
    }

    @Test
    void canInvokeSubprocessMethod() throws Exception {
        Callable subprocess = (Callable)new TestingProcess().start(MESSAGE);
        try {
            Assertions.assertEquals((Object)MESSAGE, subprocess.call());
        }
        finally {
            SubProcess.stop(subprocess);
        }
    }

    private static class TestingProcess
    extends SubProcess<Callable<String>, String>
    implements Callable<String> {
        private String message;
        private volatile transient boolean started;

        private TestingProcess() {
        }

        @Override
        protected void startup(String parameter) {
            this.message = parameter;
            this.started = true;
        }

        @Override
        public String call() throws Exception {
            while (!this.started) {
                Thread.sleep(1L);
            }
            return this.message;
        }
    }
}

