/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.resources.CpuClock;

public class FakeCpuClock
extends CpuClock
implements TestRule {
    public static final CpuClock NOT_AVAILABLE = new CpuClock(){

        public long cpuTimeNanos(long threadId) {
            return -1L;
        }
    };
    private final MutableLongLongMap cpuTimes = new LongLongHashMap();

    public long cpuTimeNanos(long threadId) {
        return Math.max(0L, this.cpuTimes.get(threadId));
    }

    public FakeCpuClock add(long delta, TimeUnit unit) {
        return this.add(unit.toNanos(delta));
    }

    public FakeCpuClock add(long nanos) {
        return this.add(Thread.currentThread().getId(), nanos);
    }

    public FakeCpuClock add(long threadId, long nanos) {
        this.cpuTimes.put(threadId, this.cpuTimeNanos(threadId) + nanos);
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }
}

