/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.Iterables;

class ListenersTest {
    ListenersTest() {
    }

    @Test
    void copyConstructorWithNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners(null));
    }

    @Test
    void copyConstructor() {
        Listeners<Listener> original = ListenersTest.newListeners(new Listener(), new Listener(), new Listener());
        Listeners copy = new Listeners(original);
        Assertions.assertEquals((Object)Iterables.asList(original), (Object)Iterables.asList((Iterable)copy));
    }

    @Test
    void addNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().add(null));
    }

    @Test
    void add() {
        Object[] listenersArray = new Listener[]{new Listener(), new Listener(), new Listener()};
        Listeners<Listener> listeners = ListenersTest.newListeners(listenersArray);
        Assertions.assertArrayEquals((Object[])listenersArray, (Object[])Iterables.asArray(Listener.class, listeners));
    }

    @Test
    void removeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().remove(null));
    }

    @Test
    void remove() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        Assertions.assertEquals(Arrays.asList(listener1, listener2, listener3), (Object)Iterables.asList(listeners));
        listeners.remove((Object)listener1);
        Assertions.assertEquals(Arrays.asList(listener2, listener3), (Object)Iterables.asList(listeners));
        listeners.remove((Object)listener3);
        Assertions.assertEquals(Collections.singletonList(listener2), (Object)Iterables.asList(listeners));
    }

    @Test
    void notifyWithNullNotification() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null));
    }

    @Test
    void notifyWithNotification() {
        String message = "foo";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        listeners.notify(listener -> listener.process(message));
        Assertions.assertEquals((Object)message, (Object)listener1.message);
        Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)listener1.threadName);
        Assertions.assertEquals((Object)message, (Object)listener2.message);
        Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)listener2.threadName);
    }

    @Test
    void notifyWithNullExecutorAndNullNotification() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null, null));
    }

    @Test
    void notifyWithNullExecutorAndNotification() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null, listener -> listener.process("foo")));
    }

    @Test
    void notifyWithExecutorAndNullNotification() {
        Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify((Executor)Executors.newSingleThreadExecutor(), null));
    }

    @Test
    void notifyWithExecutorAndNotification() throws Exception {
        String message = "foo";
        String threadNamePrefix = "test-thread";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)threadNamePrefix));
        listeners.notify((Executor)executor, listener -> listener.process(message));
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
        Assertions.assertEquals((Object)message, (Object)listener1.message);
        MatcherAssert.assertThat((Object)listener1.threadName, (Matcher)Matchers.startsWith((String)threadNamePrefix));
        Assertions.assertEquals((Object)message, (Object)listener2.message);
        MatcherAssert.assertThat((Object)listener2.threadName, (Matcher)Matchers.startsWith((String)threadNamePrefix));
    }

    @Test
    void listenersIterable() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        Assertions.assertEquals(Arrays.asList(listener1, listener2, listener3), (Object)Iterables.asList(listeners));
    }

    @SafeVarargs
    private static <T> Listeners<T> newListeners(T ... listeners) {
        Listeners result = new Listeners();
        for (T listener : listeners) {
            result.add(listener);
        }
        return result;
    }

    private static class Listener {
        volatile String message;
        volatile String threadName;

        private Listener() {
        }

        void process(String message) {
            this.message = message;
            this.threadName = Thread.currentThread().getName();
        }
    }
}

