/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.function.IntPredicate;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleIndexPopulatorUpdatesTest {
    @Mock(answer=Answers.RETURNS_MOCKS)
    private LogProvider logProvider;

    @Test
    public void updateForHigherNodeIgnoredWhenUsingFullNodeStoreScan() throws IndexPopulationFailedKernelException, IOException, IndexEntryConflictException {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        ProcessListenableNeoStoreIndexView storeView = new ProcessListenableNeoStoreIndexView(LockService.NO_LOCK_SERVICE, neoStores);
        MultipleIndexPopulator indexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, this.logProvider, EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class));
        storeView.setProcessListener(new NodeUpdateProcessListener(indexPopulator));
        IndexPopulator populator = this.createIndexPopulator();
        IndexUpdater indexUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        this.addPopulator(indexPopulator, populator, 1L, TestIndexDescriptorFactory.forLabel(1, 1));
        indexPopulator.create();
        StoreScan storeScan = indexPopulator.indexAllEntities();
        storeScan.run();
        ((IndexUpdater)Mockito.verify((Object)indexUpdater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
    }

    private NodeRecord getNodeRecord() {
        NodeRecord nodeRecord = new NodeRecord(1L);
        nodeRecord.initialize(true, 0L, false, 1L, 1L);
        InlineNodeLabels.putSorted((NodeRecord)nodeRecord, (long[])new long[]{1L}, null, null);
        return nodeRecord;
    }

    private IndexPopulator createIndexPopulator() {
        return (IndexPopulator)Mockito.mock(IndexPopulator.class);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, long indexId, IndexDescriptor descriptor) {
        return this.addPopulator(multipleIndexPopulator, descriptor.withId(indexId), indexPopulator, (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class), (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, StoreIndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return multipleIndexPopulator.addPopulator(indexPopulator, descriptor.withoutCapabilities(), flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private class ListenableNodeScanViewNodeStoreScan<FAILURE extends Exception>
    extends StoreViewNodeStoreScan<FAILURE> {
        private final Listener<StorageNodeCursor> processListener;

        ListenableNodeScanViewNodeStoreScan(StorageReader storageReader, LockService locks, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, Listener<StorageNodeCursor> processListener) {
            super(storageReader, locks, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
            this.processListener = processListener;
        }

        public boolean process(StorageNodeCursor cursor) throws FAILURE {
            this.processListener.receive((Object)cursor);
            return super.process(cursor);
        }
    }

    private class ProcessListenableNeoStoreIndexView
    extends NeoStoreIndexStoreView {
        private Listener<StorageNodeCursor> processListener;
        private NeoStores neoStores;

        ProcessListenableNeoStoreIndexView(LockService locks, NeoStores neoStores) {
            super(locks, neoStores);
            this.neoStores = neoStores;
        }

        public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
            return new ListenableNodeScanViewNodeStoreScan<FAILURE>((StorageReader)new RecordStorageReader(this.neoStores), this.locks, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, this.processListener);
        }

        void setProcessListener(Listener<StorageNodeCursor> processListener) {
            this.processListener = processListener;
        }
    }

    private static class NodeUpdateProcessListener
    implements Listener<StorageNodeCursor> {
        private final MultipleIndexPopulator indexPopulator;
        private final LabelSchemaDescriptor index;

        NodeUpdateProcessListener(MultipleIndexPopulator indexPopulator) {
            this.indexPopulator = indexPopulator;
            this.index = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        }

        public void receive(StorageNodeCursor node) {
            if (node.entityReference() == 7L) {
                this.indexPopulator.queueUpdate(IndexEntryUpdate.change((long)8L, (SchemaDescriptorSupplier)this.index, (Value)Values.of((Object)"a"), (Value)Values.of((Object)"b")));
            }
        }
    }
}

