/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.SchemaDescriptorLookupSet;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class SchemaDescriptorLookupSetTest {
    @Inject
    private RandomRule random;

    SchemaDescriptorLookupSetTest() {
    }

    @ParameterizedTest
    @EnumSource(value=DescriptorFactory.class)
    void shouldLookupSingleKeyDescriptors(DescriptorFactory factory) {
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        SchemaDescriptor expected = factory.descriptor(1, 2);
        set.add((SchemaDescriptorSupplier)expected);
        HashSet descriptors = new HashSet();
        set.matchingDescriptorsForPartialListOfProperties(descriptors, SchemaDescriptorLookupSetTest.longs(1L), SchemaDescriptorLookupSetTest.ints(2));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaDescriptor[]{expected}), descriptors);
    }

    @ParameterizedTest
    @EnumSource(value=DescriptorFactory.class)
    void shouldLookupSingleKeyAndSharedCompositeKeyDescriptors(DescriptorFactory factory) {
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        SchemaDescriptor expected1 = factory.descriptor(1, 2);
        SchemaDescriptor expected2 = factory.descriptor(1, 2, 3);
        set.add((SchemaDescriptorSupplier)expected1);
        set.add((SchemaDescriptorSupplier)expected2);
        HashSet descriptors = new HashSet();
        set.matchingDescriptorsForPartialListOfProperties(descriptors, SchemaDescriptorLookupSetTest.longs(1L), SchemaDescriptorLookupSetTest.ints(2));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaDescriptor[]{expected1, expected2}), descriptors);
    }

    @ParameterizedTest
    @EnumSource(value=DescriptorFactory.class)
    void shouldLookupCompositeKeyDescriptor(DescriptorFactory factory) {
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        SchemaDescriptor descriptor1 = factory.descriptor(1, 2, 3);
        SchemaDescriptor descriptor2 = factory.descriptor(1, 2, 4);
        SchemaDescriptor descriptor3 = factory.descriptor(1, 2, 5, 6);
        set.add((SchemaDescriptorSupplier)descriptor1);
        set.add((SchemaDescriptorSupplier)descriptor2);
        set.add((SchemaDescriptorSupplier)descriptor3);
        HashSet descriptors = new HashSet();
        set.matchingDescriptorsForCompleteListOfProperties(descriptors, SchemaDescriptorLookupSetTest.longs(1L), SchemaDescriptorLookupSetTest.ints(2, 5, 6));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaDescriptor[]{descriptor3}), descriptors);
    }

    @ParameterizedTest
    @EnumSource(value=DescriptorFactory.class)
    void shouldLookupAllByEntityToken(DescriptorFactory factory) {
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        SchemaDescriptor descriptor1 = factory.descriptor(1, 2, 3);
        SchemaDescriptor descriptor2 = factory.descriptor(1, 2, 4);
        SchemaDescriptor descriptor3 = factory.descriptor(1, 2, 5, 6);
        SchemaDescriptor descriptor4 = factory.descriptor(2, 2, 3);
        SchemaDescriptor descriptor5 = factory.descriptor(3, 2, 5, 6);
        set.add((SchemaDescriptorSupplier)descriptor1);
        set.add((SchemaDescriptorSupplier)descriptor2);
        set.add((SchemaDescriptorSupplier)descriptor3);
        set.add((SchemaDescriptorSupplier)descriptor4);
        set.add((SchemaDescriptorSupplier)descriptor5);
        HashSet descriptors = new HashSet();
        set.matchingDescriptors(descriptors, SchemaDescriptorLookupSetTest.longs(1L));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaDescriptor[]{descriptor1, descriptor2, descriptor3}), descriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"nodeAndRelationshipEntityTypes"})
    void shouldMatchOnAnyEntityAndPropertyTokenForPartialPropertySchemaType(EntityType entityType) {
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        MultiTokenSchemaDescriptor descriptor1 = SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(0, 1, 2), (EntityType)entityType, (int[])new int[]{3, 4, 5});
        MultiTokenSchemaDescriptor descriptor2 = SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(0, 1), (EntityType)entityType, (int[])new int[]{3, 4});
        MultiTokenSchemaDescriptor descriptor3 = SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(0, 2), (EntityType)entityType, (int[])new int[]{4, 5});
        set.add((SchemaDescriptorSupplier)descriptor1);
        set.add((SchemaDescriptorSupplier)descriptor2);
        set.add((SchemaDescriptorSupplier)descriptor3);
        set.add((SchemaDescriptorSupplier)SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(3, 4), (EntityType)entityType, (int[])new int[]{4, 5}));
        set.add((SchemaDescriptorSupplier)SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(0, 1), (EntityType)entityType, (int[])new int[]{6, 7}));
        set.add((SchemaDescriptorSupplier)SchemaDescriptorFactory.multiToken((int[])SchemaDescriptorLookupSetTest.ints(3, 4), (EntityType)entityType, (int[])new int[]{6, 7}));
        HashSet descriptors1 = new HashSet();
        HashSet descriptors1Partial = new HashSet();
        HashSet descriptors2 = new HashSet();
        HashSet descriptors2Partial = new HashSet();
        HashSet descriptors3 = new HashSet();
        HashSet descriptors3Partial = new HashSet();
        set.matchingDescriptorsForCompleteListOfProperties(descriptors1, SchemaDescriptorLookupSetTest.longs(0L, 1L), SchemaDescriptorLookupSetTest.ints(4, 5));
        set.matchingDescriptorsForPartialListOfProperties(descriptors1Partial, SchemaDescriptorLookupSetTest.longs(0L, 1L), SchemaDescriptorLookupSetTest.ints(4, 5));
        set.matchingDescriptorsForCompleteListOfProperties(descriptors2, SchemaDescriptorLookupSetTest.longs(0L), SchemaDescriptorLookupSetTest.ints(3));
        set.matchingDescriptorsForPartialListOfProperties(descriptors2Partial, SchemaDescriptorLookupSetTest.longs(0L), SchemaDescriptorLookupSetTest.ints(3));
        set.matchingDescriptorsForCompleteListOfProperties(descriptors3, SchemaDescriptorLookupSetTest.longs(1L), SchemaDescriptorLookupSetTest.ints(5));
        set.matchingDescriptorsForPartialListOfProperties(descriptors3Partial, SchemaDescriptorLookupSetTest.longs(1L), SchemaDescriptorLookupSetTest.ints(5));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1, descriptor2, descriptor3}), descriptors1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1, descriptor2, descriptor3}), descriptors1Partial);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1, descriptor2}), descriptors2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1, descriptor2}), descriptors2Partial);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1}), descriptors3);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new MultiTokenSchemaDescriptor[]{descriptor1}), descriptors3Partial);
    }

    @Test
    void shouldAddRemoveAndLookupRandomDescriptorsNoIdempotentOperations() {
        this.shouldAddRemoveAndLookupRandomDescriptors(false);
    }

    @Test
    void shouldAddRemoveAndLookupRandomDescriptorsWithIdempotentOperations() {
        this.shouldAddRemoveAndLookupRandomDescriptors(true);
    }

    private void shouldAddRemoveAndLookupRandomDescriptors(boolean includeIdempotentAddsAndRemoves) {
        ArrayList<SchemaDescriptor> all = new ArrayList<SchemaDescriptor>();
        SchemaDescriptorLookupSet set = new SchemaDescriptorLookupSet();
        int highEntityKeyId = 8;
        int highPropertyKeyId = 8;
        int maxNumberOfEntityKeys = 3;
        int maxNumberOfPropertyKeys = 3;
        for (int i = 0; i < 100; ++i) {
            int countToAdd = this.random.nextInt(1, 5);
            for (int a = 0; a < countToAdd; ++a) {
                SchemaDescriptor descriptor = this.randomSchemaDescriptor(highEntityKeyId, highPropertyKeyId, maxNumberOfEntityKeys, maxNumberOfPropertyKeys);
                if (!includeIdempotentAddsAndRemoves && all.indexOf(descriptor) != -1) continue;
                set.add((SchemaDescriptorSupplier)descriptor);
                all.add(descriptor);
            }
            int countToRemove = this.random.nextInt(0, 2);
            for (int r = 0; r < countToRemove && !all.isEmpty(); ++r) {
                SchemaDescriptor descriptor = (SchemaDescriptor)all.remove(this.random.nextInt(all.size()));
                set.remove((SchemaDescriptorSupplier)descriptor);
                if (!includeIdempotentAddsAndRemoves) continue;
                set.remove((SchemaDescriptorSupplier)descriptor);
                while (all.remove(descriptor)) {
                }
            }
            int countToLookup = 20;
            for (int l = 0; l < countToLookup; ++l) {
                int[] entityTokenIdsInts = this.randomUniqueSortedIntArray(highEntityKeyId, this.random.nextInt(1, 3));
                long[] entityTokenIds = SchemaDescriptorLookupSetTest.toLongArray(entityTokenIdsInts);
                int[] propertyKeyIds = this.randomUniqueSortedIntArray(highPropertyKeyId, this.random.nextInt(1, maxNumberOfPropertyKeys));
                HashSet actual = new HashSet();
                actual.clear();
                set.matchingDescriptors(actual, entityTokenIds);
                Assert.assertEquals(SchemaDescriptorLookupSetTest.expectedDescriptors(all, SchemaDescriptorLookupSetTest.filterByEntity(entityTokenIdsInts)), actual);
                actual.clear();
                set.matchingDescriptorsForPartialListOfProperties(actual, entityTokenIds, propertyKeyIds);
                Assert.assertEquals(SchemaDescriptorLookupSetTest.expectedDescriptors(all, SchemaDescriptorLookupSetTest.filterByEntityAndPropertyPartial(entityTokenIdsInts, propertyKeyIds)), actual);
                actual.clear();
                set.matchingDescriptorsForCompleteListOfProperties(actual, entityTokenIds, propertyKeyIds);
                Assert.assertEquals(SchemaDescriptorLookupSetTest.expectedDescriptors(all, SchemaDescriptorLookupSetTest.filterByEntityAndPropertyComplete(entityTokenIdsInts, propertyKeyIds)), actual);
            }
        }
    }

    private static Predicate<SchemaDescriptor> filterByEntityAndPropertyComplete(int[] entityTokenIds, int[] propertyKeyIds) {
        return descriptor -> {
            IntPredicate propertyKeyPredicate = indexPropertyId -> ArrayUtils.contains((int[])propertyKeyIds, (int)indexPropertyId);
            boolean propertiesAccepted = descriptor.propertySchemaType() == SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS ? Arrays.stream(descriptor.getPropertyIds()).allMatch(propertyKeyPredicate) : Arrays.stream(descriptor.getPropertyIds()).anyMatch(propertyKeyPredicate);
            return Arrays.stream(descriptor.getEntityTokenIds()).anyMatch(indexEntityId -> ArrayUtils.contains((int[])entityTokenIds, (int)indexEntityId)) && propertiesAccepted;
        };
    }

    private static Predicate<SchemaDescriptor> filterByEntityAndPropertyPartial(int[] entityTokenIds, int[] propertyKeyIds) {
        return descriptor -> Arrays.stream(descriptor.getEntityTokenIds()).anyMatch(indexEntityId -> ArrayUtils.contains((int[])entityTokenIds, (int)indexEntityId)) && Arrays.stream(descriptor.getPropertyIds()).anyMatch(indexPropertyId -> ArrayUtils.contains((int[])propertyKeyIds, (int)indexPropertyId));
    }

    private static Predicate<SchemaDescriptor> filterByEntity(int[] entityTokenIds) {
        return descriptor -> Arrays.stream(descriptor.getEntityTokenIds()).anyMatch(indexEntityId -> ArrayUtils.contains((int[])entityTokenIds, (int)indexEntityId));
    }

    private static Set<SchemaDescriptor> expectedDescriptors(List<SchemaDescriptor> all, Predicate<SchemaDescriptor> filter) {
        return Iterators.asSet((Iterator)Iterators.filter(filter, all.iterator()));
    }

    private SchemaDescriptor randomSchemaDescriptor(int highEntityKeyId, int highPropertyKeyId, int maxNumberOfEntityKeys, int maxNumberOfPropertyKeys) {
        int numberOfEntityKeys = this.random.nextInt(1, maxNumberOfEntityKeys);
        int[] entityKeys = this.randomUniqueUnsortedIntArray(highEntityKeyId, numberOfEntityKeys);
        int numberOfPropertyKeys = this.random.nextInt(1, maxNumberOfPropertyKeys);
        int[] propertyKeys = this.randomUniqueUnsortedIntArray(highPropertyKeyId, numberOfPropertyKeys);
        return entityKeys.length > 1 ? SchemaDescriptorFactory.multiToken((int[])entityKeys, (EntityType)EntityType.NODE, (int[])propertyKeys) : SchemaDescriptorFactory.forLabel((int)entityKeys[0], (int[])propertyKeys);
    }

    private int[] randomUniqueUnsortedIntArray(int maxValue, int length) {
        int[] array = new int[length];
        MutableIntSet seen = IntSets.mutable.empty();
        for (int i = 0; i < length; ++i) {
            int candidate;
            while (!seen.add(candidate = this.random.nextInt(maxValue))) {
            }
            array[i] = candidate;
        }
        return array;
    }

    private int[] randomUniqueSortedIntArray(int maxValue, int length) {
        int[] array = this.randomUniqueUnsortedIntArray(maxValue, length);
        Arrays.sort(array);
        return array;
    }

    private static long[] toLongArray(int[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private static int[] ints(int ... properties) {
        return properties;
    }

    private static long[] longs(long ... labels) {
        return labels;
    }

    private static EntityType[] nodeAndRelationshipEntityTypes() {
        return new EntityType[]{EntityType.NODE, EntityType.RELATIONSHIP};
    }

    static enum DescriptorFactory {
        NODE{

            @Override
            SchemaDescriptor descriptor(int labelId, int ... propertyKeyIds) {
                return SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyKeyIds);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            SchemaDescriptor descriptor(int relTypeId, int ... propertyKeyIds) {
                return SchemaDescriptorFactory.forRelType((int)relTypeId, (int[])propertyKeyIds);
            }
        };


        abstract SchemaDescriptor descriptor(int var1, int ... var2);
    }
}

