/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class SchemaIndexTestHelper {
    private SchemaIndexTestHelper() {
    }

    public static KernelExtensionFactory<SingleInstanceIndexProviderFactoryDependencies> singleInstanceIndexProviderFactory(String key, IndexProvider provider) {
        return new SingleInstanceIndexProviderFactory(key, provider);
    }

    public static IndexProxy mockIndexProxy() {
        return (IndexProxy)Mockito.mock(IndexProxy.class);
    }

    public static boolean awaitLatch(CountDownLatch latch) {
        try {
            return latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    public static void awaitIndexOnline(SchemaRead schemaRead, IndexReference index) throws IndexNotFoundKernelException {
        long start = System.currentTimeMillis();
        while (schemaRead.indexGetState(index) != InternalIndexState.ONLINE) {
            if (start + 10000L >= System.currentTimeMillis()) continue;
            throw new RuntimeException("Index didn't come online within a reasonable time.");
        }
    }

    private static class SingleInstanceIndexProviderFactory
    extends KernelExtensionFactory<SingleInstanceIndexProviderFactoryDependencies> {
        private final IndexProvider provider;

        private SingleInstanceIndexProviderFactory(String key, IndexProvider provider) {
            super(ExtensionType.DATABASE, key);
            this.provider = provider;
        }

        public Lifecycle newInstance(KernelContext context, SingleInstanceIndexProviderFactoryDependencies dependencies) {
            return this.provider;
        }
    }

    public static interface SingleInstanceIndexProviderFactoryDependencies {
        public Config config();
    }
}

