/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.ValueGroup;

public abstract class NativeIndexTestUtil<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
    static final long NON_EXISTENT_ENTITY_ID = 1000000000L;
    final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withAccessChecks(true));
    protected final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);
    StoreIndexDescriptor indexDescriptor;
    ValueCreatorUtil<KEY, VALUE> valueCreatorUtil;
    IndexLayout<KEY, VALUE> layout;
    IndexDirectoryStructure indexDirectoryStructure;
    private File indexFile;
    PageCache pageCache;
    IndexProvider.Monitor monitor = IndexProvider.Monitor.EMPTY;

    @Before
    public void setup() throws IOException {
        this.valueCreatorUtil = this.createValueCreatorUtil();
        this.indexDescriptor = this.valueCreatorUtil.indexDescriptor();
        this.layout = this.createLayout();
        this.indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.directory.directory("root")).forProvider(this.indexDescriptor.providerDescriptor());
        this.indexFile = this.indexDirectoryStructure.directoryForIndex(this.indexDescriptor.getId());
        this.fs.mkdirs(this.indexFile.getParentFile());
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    abstract ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil();

    abstract IndexLayout<KEY, VALUE> createLayout();

    private void copyValue(VALUE value, VALUE intoValue) {
        this.valueCreatorUtil.copyValue(value, intoValue);
    }

    void verifyUpdates(IndexEntryUpdate<IndexDescriptor>[] updates) throws IOException {
        Hit<KEY, VALUE>[] expectedHits = this.convertToHits(updates, (Layout<KEY, VALUE>)this.layout);
        ArrayList<Hit<KEY, VALUE>> actualHits = new ArrayList<Hit<KEY, VALUE>>();
        try (GBPTree<KEY, VALUE> tree = this.getTree();
             RawCursor<Hit<KEY, VALUE>, IOException> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy((Hit)scan.get()));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare((NativeIndexKey)h1.key(), (NativeIndexKey)h2.key());
            if (keyCompare == 0) {
                return this.valueCreatorUtil.compareIndexedPropertyValue((NativeIndexKey)h1.key(), (NativeIndexKey)h2.key());
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits.toArray(new Hit[0]), hitComparator);
    }

    GBPTree<KEY, VALUE> getTree() {
        return new GBPTreeBuilder(this.pageCache, this.getIndexFile(), this.layout).build();
    }

    private RawCursor<Hit<KEY, VALUE>, IOException> scan(GBPTree<KEY, VALUE> tree) throws IOException {
        NativeIndexKey lowest = (NativeIndexKey)this.layout.newKey();
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValueAsLowest(0, ValueGroup.UNKNOWN);
        NativeIndexKey highest = (NativeIndexKey)this.layout.newKey();
        highest.initialize(Long.MAX_VALUE);
        highest.initValueAsHighest(0, ValueGroup.UNKNOWN);
        return tree.seek((Object)lowest, (Object)highest);
    }

    private void assertSameHits(Hit<KEY, VALUE>[] expectedHits, Hit<KEY, VALUE>[] actualHits, Comparator<Hit<KEY, VALUE>> comparator) {
        Arrays.sort(expectedHits, comparator);
        Arrays.sort(actualHits, comparator);
        Assert.assertEquals((String)String.format("Array length differ%nExpected:%d, Actual:%d", expectedHits.length, actualHits.length), (long)expectedHits.length, (long)actualHits.length);
        for (int i = 0; i < expectedHits.length; ++i) {
            Hit<KEY, VALUE> expected = expectedHits[i];
            Hit<KEY, VALUE> actual = actualHits[i];
            Assert.assertEquals((String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual), (long)0L, (long)comparator.compare(expected, actual));
        }
    }

    private Hit<KEY, VALUE> deepCopy(Hit<KEY, VALUE> from) {
        NativeIndexKey intoKey = (NativeIndexKey)this.layout.newKey();
        NativeIndexValue intoValue = this.layout.newValue();
        this.layout.copyKey(from.key(), (Object)intoKey);
        this.copyValue((NativeIndexValue)from.value(), intoValue);
        return new SimpleHit<NativeIndexKey, NativeIndexValue>(intoKey, intoValue);
    }

    private Hit<KEY, VALUE>[] convertToHits(IndexEntryUpdate<IndexDescriptor>[] updates, Layout<KEY, VALUE> layout) {
        ArrayList<Hit<NativeIndexKey, NativeIndexValue>> hits = new ArrayList<Hit<NativeIndexKey, NativeIndexValue>>(updates.length);
        for (IndexEntryUpdate<IndexDescriptor> u : updates) {
            NativeIndexKey key = (NativeIndexKey)layout.newKey();
            key.initialize(u.getEntityId());
            for (int i = 0; i < u.values().length; ++i) {
                key.initFromValue(i, u.values()[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            NativeIndexValue value = (NativeIndexValue)layout.newValue();
            value.from(u.values());
            hits.add(this.hit(key, value));
        }
        return hits.toArray(new Hit[0]);
    }

    private Hit<KEY, VALUE> hit(KEY key, VALUE value) {
        return new SimpleHit<KEY, VALUE>(key, value);
    }

    void assertFilePresent() {
        Assert.assertTrue((boolean)this.fs.fileExists(this.getIndexFile()));
    }

    void assertFileNotPresent() {
        Assert.assertFalse((boolean)this.fs.fileExists(this.getIndexFile()));
    }

    void setSeed(long seed) {
        this.random.setSeed(seed);
        this.random.reset();
    }
}

