/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

public class NumberFullScanNonUniqueIndexSamplerTest
extends NativeIndexTestUtil<NumberIndexKey, NativeIndexValue> {
    @Test
    public void shouldIncludeAllValuesInTree() throws Exception {
        IndexSample sample;
        Value[] values = this.generateNumberValues();
        this.buildTree(values);
        try (GBPTree gbpTree = this.getTree();){
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, this.layout);
            sample = sampler.result();
        }
        Assert.assertEquals((long)values.length, (long)sample.sampleSize());
        Assert.assertEquals((long)ValueCreatorUtil.countUniqueValues(values), (long)sample.uniqueValues());
        Assert.assertEquals((long)values.length, (long)sample.indexSize());
    }

    private Value[] generateNumberValues() {
        ValueType[] numberTypes = RandomValues.including(t -> t.valueGroup == ValueGroup.NUMBER);
        int size = 20;
        NumberValue[] result = new NumberValue[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.random.randomValues().nextValueOfTypes(numberTypes);
        }
        return result;
    }

    private void buildTree(Value[] values) throws IOException {
        try (GBPTree gbpTree = this.getTree();){
            try (Writer writer = gbpTree.writer();){
                NumberIndexKey key = (NumberIndexKey)this.layout.newKey();
                NativeIndexValue value = this.layout.newValue();
                long nodeId = 0L;
                for (Value number : values) {
                    key.initialize(nodeId);
                    key.initFromValue(0, number, NativeIndexKey.Inclusion.NEUTRAL);
                    value.from(new Value[]{number});
                    writer.put((Object)key, (Object)value);
                    ++nodeId;
                }
            }
            gbpTree.checkpoint(IOLimiter.UNLIMITED);
        }
    }

    @Override
    protected ValueCreatorUtil<NumberIndexKey, NativeIndexValue> createValueCreatorUtil() {
        return new ValueCreatorUtil<NumberIndexKey, NativeIndexValue>(TestIndexDescriptorFactory.forLabel(42, 666).withId(0L), RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), 0.1);
    }

    @Override
    IndexLayout<NumberIndexKey, NativeIndexValue> createLayout() {
        return new NumberLayoutNonUnique();
    }
}

