/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.impl.proc.ProcedureHolder;

public class ProcedureHolderTest {
    @Test
    public void shouldGetProcedureFromHolder() {
        ProcedureHolder procHolder = new ProcedureHolder();
        QualifiedName qualifiedName = new QualifiedName(new String[0], "CaseSensitive");
        String item = "CaseSensitiveItem";
        procHolder.put(qualifiedName, (Object)item, false);
        Assert.assertThat((Object)procHolder.get(qualifiedName), (Matcher)Matchers.equalTo((Object)item));
        Assert.assertThat((Object)procHolder.idOf(qualifiedName), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void okToHaveProcsOnlyDifferByCase() {
        ProcedureHolder procHolder = new ProcedureHolder();
        procHolder.put(new QualifiedName(new String[0], "CASESENSITIVE"), (Object)"CASESENSITIVEItem", false);
        procHolder.put(new QualifiedName(new String[0], "CaseSensitive"), (Object)"CaseSensitiveItem", false);
        Assert.assertThat((Object)procHolder.get(new QualifiedName(new String[0], "CASESENSITIVE")), (Matcher)Matchers.equalTo((Object)"CASESENSITIVEItem"));
        Assert.assertThat((Object)procHolder.get(new QualifiedName(new String[0], "CaseSensitive")), (Matcher)Matchers.equalTo((Object)"CaseSensitiveItem"));
        Assert.assertThat((Object)procHolder.idOf(new QualifiedName(new String[0], "CASESENSITIVE")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)procHolder.idOf(new QualifiedName(new String[0], "CaseSensitive")), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldGetCaseInsensitiveFromHolder() {
        ProcedureHolder procHolder = new ProcedureHolder();
        QualifiedName qualifiedName = new QualifiedName(new String[0], "CaseInSensitive");
        String item = "CaseInSensitiveItem";
        procHolder.put(qualifiedName, (Object)item, true);
        QualifiedName lowerCaseName = new QualifiedName(new String[0], "caseinsensitive");
        Assert.assertThat((Object)procHolder.get(lowerCaseName), (Matcher)Matchers.equalTo((Object)item));
        Assert.assertThat((Object)procHolder.idOf(lowerCaseName), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void canOverwriteFunctionAndChangeCaseSensitivity() {
        ProcedureHolder procHolder = new ProcedureHolder();
        QualifiedName qualifiedName = new QualifiedName(new String[0], "CaseInSensitive");
        String item = "CaseInSensitiveItem";
        procHolder.put(qualifiedName, (Object)item, true);
        QualifiedName lowerCaseName = new QualifiedName(new String[0], "caseinsensitive");
        Assert.assertThat((Object)procHolder.get(lowerCaseName), (Matcher)Matchers.equalTo((Object)item));
        Assert.assertThat((Object)procHolder.idOf(lowerCaseName), (Matcher)Matchers.equalTo((Object)0));
        procHolder.put(qualifiedName, (Object)item, false);
        Assert.assertNull((Object)procHolder.get(lowerCaseName));
        try {
            procHolder.idOf(lowerCaseName);
            Assert.fail((String)"Should have failed to find with lower case");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

