/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class ReflectiveUserFunctionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler procedureCompiler;
    private ComponentRegistry components;

    @Before
    public void setUp() {
        this.components = new ComponentRegistry();
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, (Log)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    @Test
    public void shouldInjectLogging() throws KernelException {
        Log log = (Log)Mockito.spy(Log.class);
        this.components.register(Log.class, ctx -> log);
        CallableUserFunction function = (CallableUserFunction)this.procedureCompiler.compileFunction(LoggingFunction.class, false).get(0);
        function.apply((Context)new BasicContext(), new AnyValue[0]);
        ((Log)Mockito.verify((Object)log)).debug("1");
        ((Log)Mockito.verify((Object)log)).info("2");
        ((Log)Mockito.verify((Object)log)).warn("3");
        ((Log)Mockito.verify((Object)log)).error("4");
    }

    @Test
    public void shouldCompileFunction() throws Throwable {
        List<CallableUserFunction> function = this.compile(SingleReadOnlyFunction.class);
        Assert.assertEquals((long)1L, (long)function.size());
        Assert.assertThat((Object)function.get(0).signature(), (Matcher)Matchers.equalTo((Object)UserFunctionSignature.functionSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "listCoolPeople"}).out((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny)).build()));
    }

    @Test
    public void shouldRunSimpleReadOnlyFunction() throws Throwable {
        CallableUserFunction func = this.compile(SingleReadOnlyFunction.class).get(0);
        AnyValue out = func.apply((Context)new BasicContext(), new AnyValue[0]);
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.equalTo((Object)ValueUtils.of(Arrays.asList("Bonnie", "Clyde"))));
    }

    @Test
    public void shouldIgnoreClassesWithNoFunctions() throws Throwable {
        List<CallableUserFunction> functions = this.compile(PrivateConstructorButNoFunctions.class);
        Assert.assertEquals((long)0L, (long)functions.size());
    }

    @Test
    public void shouldRunClassWithMultipleFunctionsDeclared() throws Throwable {
        List<CallableUserFunction> compiled = this.compile(MultiFunction.class);
        CallableUserFunction bananaPeople = compiled.get(0);
        CallableUserFunction coolPeople = compiled.get(1);
        AnyValue coolOut = coolPeople.apply((Context)new BasicContext(), new AnyValue[0]);
        AnyValue bananaOut = bananaPeople.apply((Context)new BasicContext(), new AnyValue[0]);
        Assert.assertThat((Object)coolOut, (Matcher)CoreMatchers.equalTo((Object)ValueUtils.of(Arrays.asList("Bonnie", "Clyde"))));
        Assert.assertThat((Object)((MapValue)bananaOut).get("foo"), (Matcher)CoreMatchers.equalTo((Object)ValueUtils.of(Arrays.asList("bar", "baz"))));
    }

    @Test
    public void shouldGiveHelpfulErrorOnConstructorThatRequiresArgument() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `WierdConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(WierdConstructorFunction.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNoPublicConstructor() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `PrivateConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(PrivateConstructorFunction.class);
    }

    @Test
    public void shouldNotAllowVoidOutput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Don't know how to map `void` to the Neo4j Type System.");
        this.compile(FunctionWithVoidOutput.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnFunctionReturningInvalidType() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Don't know how to map `char[]` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: [boolean, byte[], double, java.lang.Boolean, java.lang.Double, java.lang.Long, java.lang.Number, java.lang.Object, java.lang.String, java.time.LocalDate, java.time.LocalDateTime, java.time.LocalTime, java.time.OffsetTime, java.time.ZonedDateTime, java.time.temporal.TemporalAmount, java.util.List, java.util.Map, long]", new Object[0]));
        this.compile(FunctionWithInvalidOutput.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnContextAnnotatedStaticField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("The field `gdb` in the class named `FunctionWithStaticContextAnnotatedField` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[0]));
        this.compile(FunctionWithStaticContextAnnotatedField.class).get(0);
    }

    @Test
    public void shouldAllowOverridingProcedureName() throws Throwable {
        CallableUserFunction proc = this.compile(FunctionWithOverriddenName.class).get(0);
        Assert.assertEquals((Object)"org.mystuff.thisisActuallyTheName", (Object)proc.signature().name().toString());
    }

    @Test
    public void shouldNotAllowOverridingFunctionNameWithoutNamespace() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.singleName\")");
        this.compile(FunctionWithSingleName.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNullMessageException() throws Throwable {
        CallableUserFunction proc = this.compile(FunctionThatThrowsNullMsgExceptionAtInvocation.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke function `org.neo4j.kernel.impl.proc.throwsAtInvocation`: Caused by: java.lang.IndexOutOfBoundsException");
        proc.apply((Context)new BasicContext(), new AnyValue[0]);
    }

    @Test
    public void shouldLoadWhiteListedFunction() throws Throwable {
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), (Log)NullLog.getInstance(), new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"org.neo4j.kernel.impl.proc.listCoolPeople")));
        CallableUserFunction method = this.compile(SingleReadOnlyFunction.class).get(0);
        AnyValue out = method.apply((Context)new BasicContext(), new AnyValue[0]);
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.equalTo((Object)ValueUtils.of(Arrays.asList("Bonnie", "Clyde"))));
    }

    @Test
    public void shouldNotLoadNoneWhiteListedFunction() throws Throwable {
        Log log = (Log)Mockito.spy(Log.class);
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"WrongName")));
        List<CallableUserFunction> method = this.compile(SingleReadOnlyFunction.class);
        ((Log)Mockito.verify((Object)log)).warn("The function 'org.neo4j.kernel.impl.proc.listCoolPeople' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)method.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldNotLoadAnyFunctionIfConfigIsEmpty() throws Throwable {
        Log log = (Log)Mockito.spy(Log.class);
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"")));
        List<CallableUserFunction> method = this.compile(SingleReadOnlyFunction.class);
        ((Log)Mockito.verify((Object)log)).warn("The function 'org.neo4j.kernel.impl.proc.listCoolPeople' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)method.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSupportFunctionDeprecation() throws Throwable {
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, new ComponentRegistry(), log, ProcedureConfig.DEFAULT);
        List funcs = procedureCompiler.compileFunction(FunctionWithDeprecation.class, false);
        ((Log)Mockito.verify((Object)log)).warn("Use of @UserFunction(deprecatedBy) without @Deprecated in org.neo4j.kernel.impl.proc.badFunc");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
        block9: for (CallableUserFunction func : funcs) {
            String name = func.signature().name().name();
            func.apply((Context)new BasicContext(), new AnyValue[0]);
            switch (name) {
                case "newFunc": {
                    Assert.assertFalse((String)"Should not be deprecated", (boolean)func.signature().deprecated().isPresent());
                    continue block9;
                }
                case "oldFunc": 
                case "badFunc": {
                    Assert.assertTrue((String)"Should be deprecated", (boolean)func.signature().deprecated().isPresent());
                    Assert.assertThat(func.signature().deprecated().get(), (Matcher)CoreMatchers.equalTo((Object)"newFunc"));
                    continue block9;
                }
            }
            Assert.fail((String)("Unexpected function: " + name));
        }
    }

    private List<CallableUserFunction> compile(Class<?> clazz) throws KernelException {
        return this.procedureCompiler.compileFunction(clazz, false);
    }

    public static class FunctionWithDeprecation {
        @UserFunction
        public Object newFunc() {
            return null;
        }

        @Deprecated
        @UserFunction(deprecatedBy="newFunc")
        public String oldFunc() {
            return null;
        }

        @UserFunction(deprecatedBy="newFunc")
        public Object badFunc() {
            return null;
        }
    }

    public static class FunctionWithSingleName {
        @UserFunction(value="singleName")
        public String blahDoesntMatterEither() {
            return null;
        }
    }

    public static class FunctionWithOverriddenName {
        @UserFunction(value="org.mystuff.thisisActuallyTheName")
        public Object somethingThatShouldntMatter() {
            return null;
        }
    }

    public static class PrivateConstructorButNoFunctions {
        private PrivateConstructorButNoFunctions() {
        }

        public String thisIsNotAFunction() {
            return null;
        }
    }

    public static class PrivateConstructorFunction {
        private PrivateConstructorFunction() {
        }

        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class FunctionThatThrowsNullMsgExceptionAtInvocation {
        @UserFunction
        public String throwsAtInvocation() {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class FunctionWithStaticContextAnnotatedField {
        @org.neo4j.procedure.Context
        public static GraphDatabaseService gdb;

        @UserFunction
        public Object test() {
            return null;
        }
    }

    public static class FunctionWithInvalidOutput {
        @UserFunction
        public char[] test() {
            return "Testing".toCharArray();
        }
    }

    public static class WierdConstructorFunction {
        public WierdConstructorFunction(WierdConstructorFunction wat) {
        }

        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class MultiFunction {
        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }

        @UserFunction
        public Map<String, Object> listBananaOwningPeople() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("foo", Arrays.asList("bar", "baz"));
            return map;
        }
    }

    public static class FunctionWithVoidOutput {
        @UserFunction
        public void voidOutput() {
        }
    }

    public static class SingleReadOnlyFunction {
        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class LoggingFunction {
        @org.neo4j.procedure.Context
        public Log log;

        @UserFunction
        public long logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return -1L;
        }
    }
}

