/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.EntityCommandGrouper;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.PropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionRecordState;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandlerContract;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.OnlineIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PrepareTrackingRecordFormats;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.NeoStoresRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TransactionRecordStateTest {
    @Rule
    public final NeoStoresRule neoStoresRule = new NeoStoresRule(this.getClass(), new StoreType[0]);
    private static final String LONG_STRING = "string value long enough not to be stored as a short string";
    private static final int propertyId1 = 1;
    private static final int propertyId2 = 2;
    private static final Value value1 = Values.of((Object)"first");
    private static final Value value2 = Values.of((Object)4);
    private static final long[] noLabels = new long[0];
    private final long[] oneLabelId = new long[]{3L};
    private final long[] secondLabelId = new long[]{4L};
    private final long[] bothLabelIds = new long[]{3L, 4L};
    private final IntegrityValidator integrityValidator = (IntegrityValidator)Mockito.mock(IntegrityValidator.class);
    private RecordChangeSet recordChangeSet;

    private static void assertRelationshipGroupDoesNotExist(RecordChangeSet recordChangeSet, NodeRecord node, int type) {
        Assert.assertNull(TransactionRecordStateTest.getRelationshipGroup(recordChangeSet, node, type));
    }

    private static void assertDenseRelationshipCounts(RecordChangeSet recordChangeSet, long nodeId, int type, int outCount, int inCount) {
        RelationshipRecord rel;
        RelationshipGroupRecord group = (RelationshipGroupRecord)TransactionRecordStateTest.getRelationshipGroup(recordChangeSet, (NodeRecord)recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), type).forReadingData();
        Assert.assertNotNull((Object)group);
        long relId = group.getFirstOut();
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad(relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for OUTGOING differs", (long)outCount, (long)rel.getFirstPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for OUTGOING differs", (long)outCount, (long)TransactionRecordStateTest.manuallyCountRelationships(recordChangeSet, nodeId, relId));
        }
        if ((relId = group.getFirstIn()) != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad(relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for INCOMING differs", (long)inCount, (long)rel.getSecondPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for INCOMING differs", (long)inCount, (long)TransactionRecordStateTest.manuallyCountRelationships(recordChangeSet, nodeId, relId));
        }
    }

    private static RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> getRelationshipGroup(RecordChangeSet recordChangeSet, NodeRecord node, int type) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy change = recordChangeSet.getRelGroupRecords().getOrLoad(groupId, (Object)type);
            RelationshipGroupRecord record = (RelationshipGroupRecord)change.forReadingData();
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return change;
            }
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return null;
    }

    private static int manuallyCountRelationships(RecordChangeSet recordChangeSet, long nodeId, long firstRelId) {
        int count = 0;
        long relId = firstRelId;
        while (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            ++count;
            RelationshipRecord record = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad(relId, null).forReadingData();
            relId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
        }
        return count;
    }

    @Test
    public void shouldCreateEqualEntityPropertyUpdatesOnRecoveryOfCreatedEntities() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        long relId = 1L;
        int labelId = 5;
        int relTypeId = 4;
        int propertyKeyId = 7;
        long nodeRuleId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        StoreIndexDescriptor nodeRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(nodeRuleId);
        recordState.createSchemaRule((SchemaRule)nodeRule);
        long relRuleId = 1L;
        StoreIndexDescriptor relRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(relRuleId);
        recordState.createSchemaRule((SchemaRule)relRule);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.addLabelToNode((long)labelId, nodeId);
        recordState.nodeAddProperty(nodeId, propertyKeyId, Values.of((Object)"Neo"));
        recordState.relCreate(relId, relTypeId, nodeId, nodeId);
        recordState.relAddProperty(relId, propertyKeyId, Values.of((Object)"Oen"));
        PhysicalTransactionRepresentation transaction = this.transactionRepresentationOf(recordState);
        PropertyCommandsExtractor extractor = new PropertyCommandsExtractor();
        transaction.accept((Visitor)extractor);
        Assert.assertTrue((boolean)extractor.containsAnyEntityOrPropertyUpdate());
        LongHashSet recoveredNodeIds = new LongHashSet();
        recoveredNodeIds.addAll(this.entityIds(extractor.getNodeCommands()));
        Assert.assertEquals((long)1L, (long)recoveredNodeIds.size());
        Assert.assertEquals((long)nodeId, (long)recoveredNodeIds.longIterator().next());
        LongHashSet recoveredRelIds = new LongHashSet();
        recoveredRelIds.addAll(this.entityIds(extractor.getRelationshipCommands()));
        Assert.assertEquals((long)1L, (long)recoveredRelIds.size());
        Assert.assertEquals((long)relId, (long)recoveredRelIds.longIterator().next());
    }

    @Test
    public void shouldWriteProperPropertyRecordsWhenOnlyChangingLinkage() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int nodeId = 0;
        recordState.nodeCreate((long)nodeId);
        int index = 0;
        recordState.nodeAddProperty((long)nodeId, index, this.string(70));
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        int index2 = 1;
        recordState.nodeAddProperty((long)nodeId, index2, this.string(40));
        PhysicalTransactionRepresentation representation = this.transactionRepresentationOf(recordState);
        representation.accept(command -> ((Command)command).handle((CommandVisitor)new CommandVisitor.Adapter(){

            public boolean visitPropertyCommand(Command.PropertyCommand command) {
                this.verifyPropertyRecord((PropertyRecord)command.getBefore());
                this.verifyPropertyRecord((PropertyRecord)command.getAfter());
                return false;
            }

            private void verifyPropertyRecord(PropertyRecord record) {
                if (record.getPrevProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                    for (PropertyBlock block : record) {
                        Assert.assertTrue((boolean)block.isLight());
                    }
                }
            }
        }));
    }

    @Test
    public void shouldConvertLabelAdditionToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        Value value1 = Values.of((Object)LONG_STRING);
        Value value2 = Values.of((Object)LONG_STRING.getBytes());
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        recordState.nodeAddProperty(nodeId, 2, value2);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        this.addLabelsToNode(recordState, nodeId, this.oneLabelId);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(noLabels).withTokensAfter(this.oneLabelId).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelAdditionAndSetPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        this.addLabelsToNode(recordState, nodeId, this.oneLabelId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeAddProperty(nodeId, 2, value2);
        this.addLabelsToNode(recordState, nodeId, this.secondLabelId);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(this.oneLabelId).withTokensAfter(this.bothLabelIds).added(2, value2).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertLabelRemovalToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        recordState.nodeAddProperty(nodeId, 2, value2);
        this.addLabelsToNode(recordState, nodeId, this.oneLabelId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        this.removeLabelsFromNode(recordState, nodeId, this.oneLabelId);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(this.oneLabelId).withTokensAfter(noLabels).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndRemovePropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        this.addLabelsToNode(recordState, nodeId, this.bothLabelIds);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeRemoveProperty(nodeId, 1);
        this.removeLabelsFromNode(recordState, nodeId, this.secondLabelId);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(this.bothLabelIds).withTokensAfter(this.oneLabelId).removed(1, value1).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndAddPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        this.addLabelsToNode(recordState, nodeId, this.bothLabelIds);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeAddProperty(nodeId, 2, value2);
        this.removeLabelsFromNode(recordState, nodeId, this.secondLabelId);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(this.bothLabelIds).withTokensAfter(this.oneLabelId).added(2, value2).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertChangedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        int nodeId = 0;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate((long)nodeId);
        recordState.nodeAddProperty((long)nodeId, 1, value1);
        recordState.nodeAddProperty((long)nodeId, 2, value2);
        this.apply(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(recordState));
        Value newValue1 = Values.of((Object)"new");
        Value newValue2 = Values.of((Object)"new 2");
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeChangeProperty((long)nodeId, 1, newValue1);
        recordState.nodeChangeProperty((long)nodeId, 2, newValue2);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).changed(1, value1, newValue1).changed(2, value2, newValue2).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldConvertRemovedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        int nodeId = 0;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate((long)nodeId);
        this.addLabelsToNode(recordState, nodeId, this.oneLabelId);
        recordState.nodeAddProperty((long)nodeId, 1, value1);
        recordState.nodeAddProperty((long)nodeId, 2, value2);
        this.apply(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeRemoveProperty((long)nodeId, 1);
        recordState.nodeRemoveProperty((long)nodeId, 2);
        Iterable<EntityUpdates> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(this.oneLabelId).removed(1, value1).removed(2, value2).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(indexUpdates));
    }

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNode() throws Throwable {
        NeoStores store = this.neoStoresRule.builder().build();
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((BatchTransactionApplier)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        this.apply((BatchTransactionApplier)applier, this.transaction(this.deleteNode(store, nodeId.get())));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNodeForRecoveredTransaction() throws Throwable {
        NeoStores store = this.neoStoresRule.builder().build();
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((BatchTransactionApplier)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        TransactionRepresentation transaction = this.transaction(this.deleteNode(store, nodeId.get()));
        InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
        this.writeToChannel(transaction, (FlushableChannel)channel);
        CommittedTransactionRepresentation recoveredTransaction = this.readFromChannel(channel);
        this.apply((BatchTransactionApplier)applier, recoveredTransaction.getTransactionRepresentation());
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldExtractCreatedCommandsInCorrectOrder() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId = 0L;
        long relId = 1L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId++, 0, nodeId, nodeId);
        recordState.relCreate(relId, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, value2);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldExtractUpdateCommandsInCorrectOrder() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId = 0L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId3 = 3L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId1, 0, nodeId, nodeId);
        recordState.relCreate(relId2, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, Values.of((Object)101));
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeChangeProperty(nodeId, 0, Values.of((Object)102));
        recordState.relCreate(relId3, 0, nodeId, nodeId);
        recordState.relAddProperty(relId1, 0, Values.of((Object)123));
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldIgnoreRelationshipGroupCommandsForGroupThatIsCreatedAndDeletedInThisTx() throws Exception {
        NeoStores neoStore = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "5").build();
        int relationshipA = 0;
        int relationshipB = 1;
        TransactionRecordState state = this.newTransactionRecordState(neoStore);
        state.nodeCreate(0L);
        state.relCreate(0L, relationshipA, 0L, 0L);
        state.relCreate(1L, relationshipA, 0L, 0L);
        state.relCreate(2L, relationshipA, 0L, 0L);
        state.relCreate(3L, relationshipA, 0L, 0L);
        state.relCreate(4L, relationshipB, 0L, 0L);
        this.apply(neoStore, state);
        state = this.newTransactionRecordState(neoStore);
        state.relCreate(5L, relationshipA, 0L, 0L);
        state.relDelete(4L);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        state.extractCommands(commands);
        Command.RelationshipGroupCommand group = this.singleRelationshipGroupCommand(commands);
        Assert.assertEquals((long)relationshipA, (long)((RelationshipGroupRecord)group.getAfter()).getType());
    }

    @Test
    public void shouldExtractDeleteCommandsInCorrectOrder() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId1 = 0L;
        long nodeId2 = 1L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId4 = 10L;
        recordState.nodeCreate(nodeId1);
        recordState.nodeCreate(nodeId2);
        recordState.relCreate(relId1, 0, nodeId1, nodeId1);
        recordState.relCreate(relId2, 0, nodeId1, nodeId1);
        recordState.relCreate(relId4, 1, nodeId1, nodeId1);
        recordState.nodeAddProperty(nodeId1, 0, value1);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.relDelete(relId4);
        recordState.nodeDelete(nodeId2);
        recordState.nodeRemoveProperty(nodeId1, 0);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldValidateConstraintIndexAsPartOfExtraction() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long indexId = neoStores.getSchemaStore().nextId();
        long constraintId = neoStores.getSchemaStore().nextId();
        recordState.createSchemaRule((SchemaRule)ConstraintRule.constraintRule((long)constraintId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1}), (long)indexId));
        recordState.extractCommands(new ArrayList());
        ((IntegrityValidator)Mockito.verify((Object)this.integrityValidator)).validateSchemaRule((SchemaRule)ArgumentMatchers.any());
    }

    @Test
    public void shouldCreateProperBeforeAndAfterPropertyCommandsWhenAddingProperty() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int nodeId = 1;
        recordState.nodeCreate((long)nodeId);
        recordState.nodeAddProperty((long)nodeId, 1, value1);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        recordState.extractCommands(commands);
        Command.PropertyCommand propertyCommand = this.singlePropertyCommand(commands);
        PropertyRecord before = (PropertyRecord)propertyCommand.getBefore();
        Assert.assertFalse((boolean)before.inUse());
        Assert.assertFalse((boolean)before.iterator().hasNext());
        PropertyRecord after = (PropertyRecord)propertyCommand.getAfter();
        Assert.assertTrue((boolean)after.inUse());
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)after));
    }

    @Test
    public void shouldConvertAddedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        this.addLabelsToNode(recordState, nodeId, this.oneLabelId);
        recordState.nodeAddProperty(nodeId, 1, value1);
        recordState.nodeAddProperty(nodeId, 2, value2);
        Iterable<EntityUpdates> updates = this.indexUpdatesOf(neoStores, recordState);
        EntityUpdates expected = EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(noLabels).withTokensAfter(this.oneLabelId).added(1, value1).added(2, value2).build();
        Assert.assertEquals((Object)expected, (Object)Iterables.single(updates));
    }

    @Test
    public void shouldLockUpdatedNodes() throws Exception {
        LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)new Answer<Object>(){

            public synchronized Object answer(InvocationOnMock invocation) {
                String name = invocation.getMethod().getName();
                if (name.equals("acquireNodeLock") || name.equals("acquireRelationshipLock")) {
                    return Mockito.mock(Lock.class, invocationOnMock -> null);
                }
                return null;
            }
        });
        NeoStores neoStores = this.neoStoresRule.builder().build();
        NodeStore nodeStore = neoStores.getNodeStore();
        long[] nodes = new long[]{nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId()};
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        for (int i = 1; i < nodes.length - 1; ++i) {
            tx.nodeCreate(nodes[i]);
        }
        tx.nodeAddProperty(nodes[3], 0, Values.of((Object)"old"));
        tx.nodeAddProperty(nodes[4], 0, Values.of((Object)"old"));
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), locks);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        Mockito.reset((Object[])new LockService[]{locks});
        tx = this.newTransactionRecordState(neoStores);
        tx.nodeCreate(nodes[0]);
        tx.addLabelToNode(0L, nodes[1]);
        tx.nodeAddProperty(nodes[2], 0, Values.of((Object)"value"));
        tx.nodeChangeProperty(nodes[3], 0, Values.of((Object)"value"));
        tx.nodeRemoveProperty(nodes[4], 0);
        tx.nodeDelete(nodes[5]);
        tx.nodeCreate(nodes[6]);
        tx.addLabelToNode(0L, nodes[6]);
        tx.nodeAddProperty(nodes[6], 0, Values.of((Object)"value"));
        applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), locks);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[0], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[1], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[2], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[3], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[4], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[5], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[6], LockService.LockType.WRITE_LOCK);
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() throws Exception {
        long[] relationshipsOfTypeB;
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "10").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        tx.nodeCreate(nodeId);
        int typeA = (int)neoStores.getRelationshipTypeTokenStore().nextId();
        tx.createRelationshipTypeToken("A", (long)typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 20);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        tx = this.newTransactionRecordState(neoStores);
        int typeB = 1;
        tx.createRelationshipTypeToken("B", (long)typeB);
        for (long relationshipToDelete : relationshipsOfTypeB = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 5)) {
            tx.relDelete(relationshipToDelete);
        }
        PhysicalTransactionRepresentation ptx = this.transactionRepresentationOf(tx);
        this.apply((BatchTransactionApplier)applier, (TransactionRepresentation)ptx);
        final AtomicBoolean foundRelationshipGroupInUse = new AtomicBoolean();
        ptx.accept(command -> ((Command)command).handle((CommandVisitor)new CommandVisitor.Adapter(){

            public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
                if (((RelationshipGroupRecord)command.getAfter()).inUse()) {
                    if (!foundRelationshipGroupInUse.get()) {
                        foundRelationshipGroupInUse.set(true);
                    } else {
                        Assert.fail();
                    }
                }
                return false;
            }
        }));
        Assert.assertTrue((String)"Did not create relationship group command", (boolean)foundRelationshipGroupInUse.get());
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithDifferentTypes() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "50").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        int typeB = 1;
        int typeC = 2;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", (long)typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 6);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 7);
        tx.createRelationshipTypeToken("B", (long)typeB);
        this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 8);
        this.createRelationships(neoStores, tx, nodeId, typeB, Direction.INCOMING, 9);
        tx.createRelationshipTypeToken("C", (long)typeC);
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.OUTGOING, 10);
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 10);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 6, 7);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 8, 9);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 10, 11);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeDifferentDirection() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "49").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", (long)typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 24);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 25);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 24, 26);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeSameDirection() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "8").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", (long)typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 8);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 9, 0);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithOneType() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "13").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        int nodeId = (int)neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken("A", (long)typeA);
        long[] relationshipsCreated = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 15);
        tx.relDelete(relationshipsCreated[0]);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 0, 14);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithManyTypes() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        int typeB = 12;
        int typeC = 600;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", (long)typeA);
        long[] relationshipsCreatedAIncoming = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 1);
        long[] relationshipsCreatedAOutgoing = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("B", (long)typeB);
        long[] relationshipsCreatedBIncoming = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.INCOMING, 1);
        long[] relationshipsCreatedBOutgoing = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("C", (long)typeC);
        long[] relationshipsCreatedCIncoming = this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 1);
        long[] relationshipsCreatedCOutgoing = this.createRelationships(neoStores, tx, nodeId, typeC, Direction.OUTGOING, 1);
        tx.relDelete(relationshipsCreatedAIncoming[0]);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 1, 0);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 1);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedAOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 1);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedBIncoming[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 0);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedBOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedCIncoming[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 0);
        tx.relDelete(relationshipsCreatedCOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forReadingData(), typeC);
    }

    @Test
    public void shouldSortRelationshipGroups() throws Throwable {
        int type5 = 5;
        int type10 = 10;
        int type15 = 15;
        NeoStores neoStores = this.neoStoresRule.builder().with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        neoStores.getRelationshipTypeTokenStore().setHighId(16L);
        recordState.createRelationshipTypeToken("5", (long)type5);
        recordState.createRelationshipTypeToken("10", (long)type10);
        recordState.createRelationshipTypeToken("15", (long)type15);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        long nodeId = neoStores.getNodeStore().nextId();
        long otherNode1Id = neoStores.getNodeStore().nextId();
        long otherNode2Id = neoStores.getNodeStore().nextId();
        TransactionRecordState recordState2 = this.newTransactionRecordState(neoStores);
        recordState2.nodeCreate(nodeId);
        recordState2.nodeCreate(otherNode1Id);
        recordState2.nodeCreate(otherNode2Id);
        recordState2.relCreate(neoStores.getRelationshipStore().nextId(), type10, nodeId, otherNode1Id);
        recordState2.relCreate(neoStores.getRelationshipStore().nextId(), type10, nodeId, otherNode2Id);
        NeoStoreBatchTransactionApplier applier2 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier2, this.transaction(recordState2));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type10);
        TransactionRecordState recordState3 = this.newTransactionRecordState(neoStores);
        long otherNodeId = neoStores.getNodeStore().nextId();
        recordState3.nodeCreate(otherNodeId);
        recordState3.relCreate(neoStores.getRelationshipStore().nextId(), type5, nodeId, otherNodeId);
        NeoStoreBatchTransactionApplier applier3 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier3, this.transaction(recordState3));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type5, type10);
        recordState3 = this.newTransactionRecordState(neoStores);
        otherNodeId = neoStores.getNodeStore().nextId();
        recordState3.nodeCreate(otherNodeId);
        recordState3.relCreate(neoStores.getRelationshipStore().nextId(), type15, nodeId, otherNodeId);
        applier3 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier3, this.transaction(recordState3));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type5, type10, type15);
    }

    @Test
    public void shouldPrepareRelevantRecords() throws Exception {
        PrepareTrackingRecordFormats format = new PrepareTrackingRecordFormats(Standard.LATEST_RECORD_FORMATS);
        NeoStores neoStores = this.neoStoresRule.builder().with(format).with(GraphDatabaseSettings.dense_node_threshold.name(), "1").build();
        TransactionRecordState state = this.newTransactionRecordState(neoStores);
        state.nodeCreate(0L);
        state.relCreate(0L, 0, 0L, 0L);
        state.relCreate(1L, 0, 0L, 0L);
        state.relCreate(2L, 0, 0L, 0L);
        ArrayList commands = new ArrayList();
        state.extractCommands(commands);
        int nodes = 0;
        int rels = 0;
        int groups = 0;
        for (StorageCommand command : commands) {
            if (command instanceof Command.NodeCommand) {
                Assert.assertTrue((boolean)format.node().prepared(((Command.NodeCommand)command).getAfter()));
                ++nodes;
                continue;
            }
            if (command instanceof Command.RelationshipCommand) {
                Assert.assertTrue((boolean)format.relationship().prepared(((Command.RelationshipCommand)command).getAfter()));
                ++rels;
                continue;
            }
            if (!(command instanceof Command.RelationshipGroupCommand)) continue;
            Assert.assertTrue((boolean)format.relationshipGroup().prepared(((Command.RelationshipGroupCommand)command).getAfter()));
            ++groups;
        }
        Assert.assertEquals((long)1L, (long)nodes);
        Assert.assertEquals((long)3L, (long)rels);
        Assert.assertEquals((long)1L, (long)groups);
    }

    private void addLabelsToNode(TransactionRecordState recordState, long nodeId, long[] labelIds) {
        for (long labelId : labelIds) {
            recordState.addLabelToNode((long)((int)labelId), nodeId);
        }
    }

    private void removeLabelsFromNode(TransactionRecordState recordState, long nodeId, long[] labelIds) {
        for (long labelId : labelIds) {
            recordState.removeLabelFromNode((long)((int)labelId), nodeId);
        }
    }

    private long[] createRelationships(NeoStores neoStores, TransactionRecordState tx, long nodeId, int type, Direction direction, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long relId;
            long otherNodeId = neoStores.getNodeStore().nextId();
            tx.nodeCreate(otherNodeId);
            long first = direction == Direction.OUTGOING ? nodeId : otherNodeId;
            long other = direction == Direction.INCOMING ? nodeId : otherNodeId;
            result[i] = relId = neoStores.getRelationshipStore().nextId();
            tx.relCreate(relId, type, first, other);
        }
        return result;
    }

    private void assertRelationshipGroupsInOrder(NeoStores neoStores, long nodeId, int ... types) {
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
        Assert.assertTrue((String)("Node should be dense, is " + node), (boolean)node.isDense());
        long groupId = node.getNextRel();
        int cursor = 0;
        ArrayList<RelationshipGroupRecord> seen = new ArrayList<RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
            RelationshipGroupRecord group = (RelationshipGroupRecord)relationshipGroupStore.getRecord(groupId, relationshipGroupStore.newRecord(), RecordLoad.NORMAL);
            seen.add(group);
            Assert.assertEquals((String)("Invalid type, seen groups so far " + seen), (long)types[cursor++], (long)group.getType());
            groupId = group.getNext();
        }
        Assert.assertEquals((String)("Not enough relationship group records found in chain for " + node), (long)types.length, (long)cursor);
    }

    private Iterable<EntityUpdates> indexUpdatesOf(NeoStores neoStores, TransactionRecordState state) throws IOException, TransactionFailureException {
        return this.indexUpdatesOf(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(state));
    }

    private Iterable<EntityUpdates> indexUpdatesOf(NeoStores neoStores, TransactionRepresentation transaction) throws IOException {
        PropertyCommandsExtractor extractor = new PropertyCommandsExtractor();
        transaction.accept((Visitor)extractor);
        CollectingIndexingUpdateService indexingUpdateService = new CollectingIndexingUpdateService();
        OnlineIndexUpdates onlineIndexUpdates = new OnlineIndexUpdates(neoStores.getNodeStore(), neoStores.getRelationshipStore(), (IndexingUpdateService)indexingUpdateService, new PropertyPhysicalToLogicalConverter(neoStores.getPropertyStore()));
        onlineIndexUpdates.feed(extractor.getNodeCommands(), extractor.getRelationshipCommands());
        return indexingUpdateService.entityUpdatesList;
    }

    private PhysicalTransactionRepresentation transactionRepresentationOf(TransactionRecordState writeTransaction) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        writeTransaction.extractCommands(commands);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }

    private void assertCommand(StorageCommand next, Class<?> klass) {
        Assert.assertTrue((String)("Expected " + klass + ". was: " + next), (boolean)klass.isInstance(next));
    }

    private CommittedTransactionRepresentation readFromChannel(ReadableLogChannel channel) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor cursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel, (LogEntryReader)logEntryReader);){
            Assert.assertTrue((boolean)cursor.next());
            CommittedTransactionRepresentation committedTransactionRepresentation = cursor.get();
            return committedTransactionRepresentation;
        }
    }

    private void writeToChannel(TransactionRepresentation transaction, FlushableChannel channel) throws IOException {
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((WritableChannel)channel));
        writer.append(transaction, 2L);
    }

    private TransactionRecordState nodeWithDynamicLabelRecord(NeoStores store, AtomicLong nodeId, AtomicLong dynamicLabelRecordId) {
        TransactionRecordState recordState = this.newTransactionRecordState(store);
        nodeId.set(store.getNodeStore().nextId());
        int[] labelIds = new int[20];
        for (int i = 0; i < labelIds.length; ++i) {
            int labelId = (int)store.getLabelTokenStore().nextId();
            recordState.createLabelToken("Label" + i, (long)labelId);
            labelIds[i] = labelId;
        }
        recordState.nodeCreate(nodeId.get());
        for (int labelId : labelIds) {
            recordState.addLabelToNode((long)labelId, nodeId.get());
        }
        NodeRecord node = (NodeRecord)((RecordAccess.RecordProxy)Iterables.single((Iterable)this.recordChangeSet.getNodeRecords().changes())).forReadingData();
        dynamicLabelRecordId.set(((DynamicRecord)Iterables.single((Iterable)node.getDynamicLabelRecords())).getId());
        return recordState;
    }

    private TransactionRecordState deleteNode(NeoStores store, long nodeId) {
        TransactionRecordState recordState = this.newTransactionRecordState(store);
        recordState.nodeDelete(nodeId);
        return recordState;
    }

    private void apply(BatchTransactionApplier applier, TransactionRepresentation transaction) throws Exception {
        CommandHandlerContract.apply(applier, new TransactionToApply(transaction));
    }

    private void apply(NeoStores neoStores, TransactionRepresentation transaction) throws Exception {
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, transaction);
    }

    private void apply(NeoStores neoStores, TransactionRecordState state) throws Exception {
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, (TransactionRepresentation)this.transactionRepresentationOf(state));
    }

    private TransactionRecordState newTransactionRecordState(NeoStores neoStores) {
        Loaders loaders = new Loaders(neoStores);
        this.recordChangeSet = new RecordChangeSet(loaders);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter((IdSequence)neoStores.getRelationshipGroupStore());
        PropertyDeleter propertyDeleter = new PropertyDeleter(propertyTraverser);
        return new TransactionRecordState(neoStores, this.integrityValidator, this.recordChangeSet, 0L, (ResourceLocker)new NoOpClient(), new RelationshipCreator(relationshipGroupGetter, neoStores.getRelationshipGroupStore().getStoreHeaderInt()), new RelationshipDeleter(relationshipGroupGetter, propertyDeleter), new PropertyCreator(neoStores.getPropertyStore(), propertyTraverser), propertyDeleter);
    }

    private TransactionRepresentation transaction(TransactionRecordState recordState) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return transaction;
    }

    private void assertDynamicLabelRecordInUse(NeoStores store, long id, boolean inUse) {
        DynamicArrayStore dynamicLabelStore = store.getNodeStore().getDynamicLabelStore();
        DynamicRecord record = (DynamicRecord)dynamicLabelStore.getRecord(id, (AbstractBaseRecord)dynamicLabelStore.nextRecord(), RecordLoad.FORCE);
        Assert.assertEquals((Object)inUse, (Object)record.inUse());
    }

    private Value string(int length) {
        StringBuilder result = new StringBuilder();
        int ch = 97;
        for (int i = 0; i < length; ++i) {
            result.append((char)(ch + i % 10));
        }
        return Values.of((Object)result.toString());
    }

    private Command.PropertyCommand singlePropertyCommand(Collection<StorageCommand> commands) {
        return (Command.PropertyCommand)Iterables.single((Iterable)Iterables.filter(t -> t instanceof Command.PropertyCommand, commands));
    }

    private Command.RelationshipGroupCommand singleRelationshipGroupCommand(Collection<StorageCommand> commands) {
        return (Command.RelationshipGroupCommand)Iterables.single((Iterable)Iterables.filter(t -> t instanceof Command.RelationshipGroupCommand, commands));
    }

    public LongIterable entityIds(EntityCommandGrouper.Cursor cursor) {
        LongArrayList list = new LongArrayList();
        if (cursor.nextEntity()) {
            while (cursor.nextProperty() != null) {
            }
            list.add(cursor.currentEntityId());
        }
        return list;
    }

    private class CollectingIndexingUpdateService
    implements IndexingUpdateService {
        final List<EntityUpdates> entityUpdatesList = new ArrayList<EntityUpdates>();

        private CollectingIndexingUpdateService() {
        }

        public void apply(IndexUpdates updates) {
        }

        public Iterable<IndexEntryUpdate<SchemaDescriptor>> convertToIndexUpdates(EntityUpdates entityUpdates, EntityType type) {
            this.entityUpdatesList.add(entityUpdates);
            return Iterables.empty();
        }
    }
}

