/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.LongSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CommonAbstractStoreTest {
    private static final int PAGE_SIZE = 32;
    private static final int RECORD_SIZE = 10;
    private static final int HIGH_ID = 42;
    private final IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
    private final IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
    private final PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
    private final PagedFile pageFile = (PagedFile)Mockito.mock(PagedFile.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private final Config config = Config.defaults();
    private final File storeFile = new File("store");
    private final File idStoreFile = new File("isStore");
    private final RecordFormat<TheRecord> recordFormat = (RecordFormat)Mockito.mock(RecordFormat.class);
    private final IdType idType = IdType.RELATIONSHIP;
    private static final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private static final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)fileSystemRule.get());
    private static final ConfigurablePageCacheRule pageCacheRule = new ConfigurablePageCacheRule();
    @ClassRule
    public static final RuleChain ruleChain = RuleChain.outerRule((TestRule)fileSystemRule).around((TestRule)dir).around((TestRule)pageCacheRule);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUpMocks() throws IOException {
        Mockito.when((Object)this.idGeneratorFactory.open((File)ArgumentMatchers.any(File.class), (IdType)ArgumentMatchers.eq((Object)this.idType), (LongSupplier)ArgumentMatchers.any(LongSupplier.class), ArgumentMatchers.anyLong())).thenReturn((Object)this.idGenerator);
        Mockito.when((Object)this.pageFile.pageSize()).thenReturn((Object)32);
        Mockito.when((Object)this.pageFile.io(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)this.pageCursor);
        Mockito.when((Object)this.pageCache.map((File)ArgumentMatchers.eq((Object)this.storeFile), ArgumentMatchers.anyInt(), new OpenOption[0])).thenReturn((Object)this.pageFile);
    }

    @Test
    public void shouldCloseStoreFileFirstAndIdGeneratorAfter() throws Throwable {
        TheStore store = this.newStore();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.pageFile, this.idGenerator});
        store.close();
        ((PagedFile)inOrder.verify((Object)this.pageFile, Mockito.times((int)1))).close();
        ((IdGenerator)inOrder.verify((Object)this.idGenerator, Mockito.times((int)1))).close();
    }

    @Test
    public void failStoreInitializationWhenHeaderRecordCantBeRead() throws IOException {
        File storeFile = dir.file("a");
        File idFile = dir.file("idFile");
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFile = (PagedFile)Mockito.mock(PagedFile.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)pageCache.map((File)ArgumentMatchers.eq((Object)storeFile), ArgumentMatchers.anyInt(), new OpenOption[]{(OpenOption)ArgumentMatchers.any(OpenOption.class)})).thenReturn((Object)pagedFile);
        Mockito.when((Object)pagedFile.io(0L, 1)).thenReturn((Object)pageCursor);
        Mockito.when((Object)pageCursor.next()).thenReturn((Object)false);
        RecordFormats recordFormats = Standard.LATEST_RECORD_FORMATS;
        this.expectedException.expect(StoreNotFoundException.class);
        this.expectedException.expectMessage("Fail to read header record of store file: " + storeFile.getAbsolutePath());
        try (DynamicArrayStore dynamicArrayStore = new DynamicArrayStore(storeFile, idFile, this.config, IdType.NODE_LABELS, this.idGeneratorFactory, pageCache, (LogProvider)NullLogProvider.getInstance(), ((Integer)Settings.INTEGER.apply(GraphDatabaseSettings.label_block_size.getDefaultValue())).intValue(), recordFormats, new OpenOption[0]);){
            dynamicArrayStore.initialise(false);
        }
    }

    @Test
    public void throwsWhenRecordWithNegativeIdIsUpdated() {
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(-1L);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NegativeIdException.class));
        }
    }

    @Test
    public void throwsWhenRecordWithTooHighIdIsUpdated() {
        long maxFormatId = 42L;
        Mockito.when((Object)this.recordFormat.getMaxId()).thenReturn((Object)maxFormatId);
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(maxFormatId + 1L);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void throwsWhenRecordWithReservedIdIsUpdated() {
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(0xFFFFFFFFL);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReservedIdException.class));
        }
    }

    @Test
    public void shouldDeleteOnCloseIfOpenOptionsSaysSo() {
        DatabaseLayout databaseLayout = dir.databaseLayout();
        File nodeStore = databaseLayout.nodeStore();
        File idFile = (File)databaseLayout.idFile(DatabaseFile.NODE_STORE).orElseThrow(() -> new IllegalStateException("Node store id file not found."));
        FileSystemAbstraction fs = fileSystemRule.get();
        PageCache pageCache = pageCacheRule.getPageCache(fs, Config.defaults());
        TheStore store = new TheStore(nodeStore, databaseLayout.idNodeStore(), this.config, this.idType, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), pageCache, (LogProvider)NullLogProvider.getInstance(), this.recordFormat, StandardOpenOption.DELETE_ON_CLOSE);
        store.initialise(true);
        store.makeStoreOk();
        Assert.assertTrue((boolean)fs.fileExists(nodeStore));
        Assert.assertTrue((boolean)fs.fileExists(idFile));
        store.close();
        Assert.assertFalse((boolean)fs.fileExists(nodeStore));
        Assert.assertFalse((boolean)fs.fileExists(idFile));
    }

    private TheStore newStore() {
        NullLogProvider log = NullLogProvider.getInstance();
        TheStore store = new TheStore(this.storeFile, this.idStoreFile, this.config, this.idType, this.idGeneratorFactory, this.pageCache, (LogProvider)log, this.recordFormat, new OpenOption[0]);
        store.initialise(false);
        return store;
    }

    private TheRecord newRecord(long id) {
        return new TheRecord(id);
    }

    private static class TheRecord
    extends AbstractBaseRecord {
        TheRecord(long id) {
            super(id);
        }

        public TheRecord clone() {
            return (TheRecord)super.clone();
        }
    }

    private static class TheStore
    extends CommonAbstractStore<TheRecord, NoStoreHeader> {
        TheStore(File file, File idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormat<TheRecord> recordFormat, OpenOption ... openOptions) {
            super(file, idFile, configuration, idType, idGeneratorFactory, pageCache, logProvider, "TheType", recordFormat, (StoreHeaderFormat)NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, "v1", openOptions);
        }

        protected void initialiseNewStoreFile(PagedFile file) {
        }

        protected int determineRecordSize() {
            return 10;
        }

        public long scanForHighId() {
            return 42L;
        }

        public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, TheRecord record) {
        }
    }
}

