/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class IdContainerTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private FileSystemAbstraction fs;
    private File file;

    @Before
    public void setUp() {
        this.fs = this.fileSystemRule.get();
        this.file = this.testDirectory.file("ids");
    }

    @Test
    public void includeFileNameIntoReadHeaderException() throws IOException {
        this.createEmptyFile();
        this.fs.truncate(this.file, 0L);
        try {
            IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
            idContainer.init();
        }
        catch (InvalidIdGeneratorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)this.file.getAbsolutePath()));
        }
    }

    @Test
    public void shouldDeleteIfOpen() {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.delete();
        Assert.assertFalse((boolean)this.fs.fileExists(this.file));
        idContainer.close(0L);
    }

    @Test
    public void shouldDeleteIfClosed() {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.close(0L);
        idContainer.delete();
        Assert.assertFalse((boolean)this.fs.fileExists(this.file));
    }

    @Test
    public void shouldForceStickyMark() throws Exception {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        try {
            IdContainer.readHighId((FileSystemAbstraction)this.fs, (File)this.file);
            Assert.fail((String)"Should have thrown, saying something with sticky generator");
        }
        catch (InvalidIdGeneratorException invalidIdGeneratorException) {
        }
        finally {
            idContainer.close(0L);
        }
    }

    @Test
    public void shouldTruncateTheFileIfOverwriting() throws Exception {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)30L, (boolean)false);
        IdContainer idContainer = new IdContainer(this.fs, this.file, 5, false);
        idContainer.init();
        for (int i = 0; i < 17; ++i) {
            idContainer.freeId((long)i);
        }
        idContainer.close(30L);
        Assert.assertThat((Object)((int)this.fs.getFileSize(this.file)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(9)));
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)30L, (boolean)false);
        Assert.assertEquals((long)9L, (long)((int)this.fs.getFileSize(this.file)));
        Assert.assertEquals((long)30L, (long)IdContainer.readHighId((FileSystemAbstraction)this.fs, (File)this.file));
        idContainer = new IdContainer(this.fs, this.file, 5, false);
        idContainer.init();
        Assert.assertEquals((long)30L, (long)idContainer.getInitialHighId());
        idContainer.close(30L);
    }

    @Test
    public void shouldReturnFalseOnInitIfTheFileWasCreated() {
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        Assert.assertFalse((boolean)idContainer.init());
        idContainer.close(100L);
    }

    @Test
    public void shouldReturnTrueOnInitIfAProperFileWasThere() {
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.close(100L);
        idContainer = new IdContainer(this.fs, this.file, 100, false);
        Assert.assertTrue((boolean)idContainer.init());
        idContainer.close(100L);
    }

    @Test
    public void idContainerReadWriteBySingleByte() throws IOException {
        SingleByteFileSystemAbstraction fileSystem = new SingleByteFileSystemAbstraction();
        IdContainer idContainer = new IdContainer((FileSystemAbstraction)fileSystem, this.file, 100, false);
        idContainer.init();
        idContainer.close(100L);
        idContainer = new IdContainer((FileSystemAbstraction)fileSystem, this.file, 100, false);
        idContainer.init();
        Assert.assertEquals((long)100L, (long)idContainer.getInitialHighId());
        fileSystem.close();
        idContainer.close(100L);
    }

    private void createEmptyFile() {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)42L, (boolean)false);
    }

    private static class SingleByteBufferChannel
    extends StoreFileChannel {
        SingleByteBufferChannel(StoreFileChannel channel) {
            super(channel);
        }

        public int write(ByteBuffer src) throws IOException {
            byte b = src.get();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{b});
            return super.write(byteBuffer);
        }

        public int read(ByteBuffer dst) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            int read = super.read(byteBuffer);
            if (read > 0) {
                byteBuffer.flip();
                dst.put(byteBuffer.get());
            }
            return read;
        }
    }

    private static class SingleByteFileSystemAbstraction
    extends DefaultFileSystemAbstraction {
        private SingleByteFileSystemAbstraction() {
        }

        public StoreFileChannel open(File fileName, OpenMode mode) throws IOException {
            return new SingleByteBufferChannel(super.open(fileName, mode));
        }
    }
}

