/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TransactionLogFileTest {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final LifeRule life = new LifeRule(true);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.life);
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(2L, 0L, 0L, 0L, 0L);

    @Test
    public void skipLogFileWithoutHeader() throws IOException {
        FileSystemAbstraction fs = this.fileSystemRule.get();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        this.logVersionRepository.incrementAndGetVersion();
        fs.create(logFiles.getLogFileForVersion(this.logVersionRepository.getCurrentLogVersion())).close();
        this.transactionIdStore.transactionCommitted(5L, 5L, 5L);
        PhysicalLogicalTransactionStore.LogVersionLocator versionLocator = new PhysicalLogicalTransactionStore.LogVersionLocator(4L);
        logFiles.accept((LogHeaderVisitor)versionLocator);
        LogPosition logPosition = versionLocator.getLogPosition();
        Assert.assertEquals((long)1L, (long)logPosition.getLogVersion());
    }

    @Test
    public void shouldOpenInFreshDirectoryAndFinallyAddHeader() throws Exception {
        String name = "log";
        FileSystemAbstraction fs = this.fileSystemRule.get();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        this.life.shutdown();
        File file = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.directory.databaseDir(), (FileSystemAbstraction)fs).build().getLogFileForVersion(1L);
        LogHeader header = LogHeaderReader.readLogHeader((FileSystemAbstraction)fs, (File)file);
        Assert.assertEquals((long)1L, (long)header.logVersion);
        Assert.assertEquals((long)2L, (long)header.lastCommittedTxId);
    }

    @Test
    public void shouldWriteSomeDataIntoTheLog() throws Exception {
        String name = "log";
        FileSystemAbstraction fs = this.fileSystemRule.get();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        FlushablePositionAwareChannel writer = logFiles.getLogFile().getWriter();
        LogPositionMarker positionMarker = new LogPositionMarker();
        writer.getCurrentPosition(positionMarker);
        int intValue = 45;
        long longValue = 4854587L;
        writer.putInt(intValue);
        writer.putLong(longValue);
        writer.prepareForFlush().flush();
        try (ReadableLogChannel reader = logFiles.getLogFile().getReader(positionMarker.newPosition());){
            Assert.assertEquals((long)intValue, (long)reader.getInt());
            Assert.assertEquals((long)longValue, (long)reader.getLong());
        }
    }

    @Test
    public void shouldReadOlderLogs() throws Exception {
        FileSystemAbstraction fs = this.fileSystemRule.get();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChannel writer = logFile.getWriter();
        LogPositionMarker positionMarker = new LogPositionMarker();
        writer.getCurrentPosition(positionMarker);
        LogPosition position1 = positionMarker.newPosition();
        int intValue = 45;
        long longValue = 4854587L;
        byte[] someBytes = TransactionLogFileTest.someBytes(40);
        writer.putInt(intValue);
        writer.putLong(longValue);
        writer.put(someBytes, someBytes.length);
        writer.prepareForFlush().flush();
        writer.getCurrentPosition(positionMarker);
        LogPosition position2 = positionMarker.newPosition();
        long longValue2 = 123456789L;
        writer.putLong(longValue2);
        writer.put(someBytes, someBytes.length);
        writer.prepareForFlush().flush();
        try (ReadableLogChannel reader = logFile.getReader(position1);){
            Assert.assertEquals((long)intValue, (long)reader.getInt());
            Assert.assertEquals((long)longValue, (long)reader.getLong());
            Assert.assertArrayEquals((byte[])someBytes, (byte[])TransactionLogFileTest.readBytes((ReadableClosableChannel)reader, 40));
        }
        reader = logFile.getReader(position2);
        var15_13 = null;
        try {
            Assert.assertEquals((long)longValue2, (long)reader.getLong());
            Assert.assertArrayEquals((byte[])someBytes, (byte[])TransactionLogFileTest.readBytes((ReadableClosableChannel)reader, 40));
        }
        catch (Throwable throwable) {
            var15_13 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var15_13 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var15_13.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void shouldVisitLogFile() throws Exception {
        String name = "log";
        FileSystemAbstraction fs = this.fileSystemRule.get();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChannel writer = logFile.getWriter();
        LogPositionMarker mark = new LogPositionMarker();
        writer.getCurrentPosition(mark);
        for (int i = 0; i < 5; ++i) {
            writer.put((byte)i);
        }
        writer.prepareForFlush();
        AtomicBoolean called = new AtomicBoolean();
        logFile.accept(channel -> {
            for (int i = 0; i < 5; ++i) {
                Assert.assertEquals((long)((byte)i), (long)channel.get());
            }
            called.set(true);
            return true;
        }, mark.newPosition());
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void shouldCloseChannelInFailedAttemptToReadHeaderAfterOpen() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        int logVersion = 0;
        File logFile = logFiles.getLogFileForVersion((long)logVersion);
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)channel.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)8);
        Mockito.when((Object)fs.fileExists(logFile)).thenReturn((Object)true);
        Mockito.when((Object)fs.open((File)ArgumentMatchers.eq((Object)logFile), (OpenMode)ArgumentMatchers.any(OpenMode.class))).thenReturn((Object)channel);
        try {
            logFiles.openForVersion((long)logVersion);
            Assert.fail((String)"Should have failed");
        }
        catch (IncompleteLogHeaderException e) {
            ((StoreChannel)Mockito.verify((Object)channel)).close();
        }
    }

    @Test
    public void shouldSuppressFailureToCloseChannelInFailedAttemptToReadHeaderAfterOpen() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).build();
        int logVersion = 0;
        File logFile = logFiles.getLogFileForVersion((long)logVersion);
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)channel.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)8);
        Mockito.when((Object)fs.fileExists(logFile)).thenReturn((Object)true);
        Mockito.when((Object)fs.open((File)ArgumentMatchers.eq((Object)logFile), (OpenMode)ArgumentMatchers.any(OpenMode.class))).thenReturn((Object)channel);
        ((StoreChannel)Mockito.doThrow(IOException.class).when((Object)channel)).close();
        try {
            logFiles.openForVersion((long)logVersion);
            Assert.fail((String)"Should have failed");
        }
        catch (IncompleteLogHeaderException e) {
            ((StoreChannel)Mockito.verify((Object)channel)).close();
            Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
            Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof IOException));
        }
    }

    private static byte[] readBytes(ReadableClosableChannel reader, int length) throws IOException {
        byte[] result = new byte[length];
        reader.get(result, length);
        return result;
    }

    private static byte[] someBytes(int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(i % 5);
        }
        return result;
    }
}

