/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.Value;

class DefaultIndexReaderTest {
    DefaultIndexReaderTest() {
    }

    @Test
    void defaultQueryImplementationMustThrowForUnsupportedIndexOrder() {
        IndexReader indexReader = DefaultIndexReaderTest.stubIndexReader();
        String expectedMessage = String.format("This reader only have support for index order %s. Provided index order was %s.", IndexOrder.NONE, IndexOrder.ASCENDING);
        UnsupportedOperationException operationException = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> indexReader.query((IndexProgressor.NodeValueClient)new SimpleNodeValueClient(), IndexOrder.ASCENDING, false, new IndexQuery[]{IndexQuery.exists((int)1)}));
        Assertions.assertEquals((Object)expectedMessage, (Object)operationException.getMessage());
    }

    private static IndexReader stubIndexReader() {
        return new AbstractIndexReader(null){

            public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
                return 0L;
            }

            public IndexSampler createSampler() {
                return null;
            }

            public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
                return null;
            }

            public boolean hasFullValuePrecision(IndexQuery ... predicates) {
                return false;
            }

            public void distinctValues(IndexProgressor.NodeValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
            }

            public void close() {
            }
        };
    }
}

