/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicIntArrayTest {
    @Test
    public void shouldWorkOnSingleChunk() {
        int defaultValue = 0;
        IntArray array = NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newDynamicIntArray(10L, defaultValue);
        array.set(4L, 5);
        Assert.assertEquals((long)5L, (long)array.get(4L));
        Assert.assertEquals((long)defaultValue, (long)array.get(12L));
        array.set(7L, 1324);
        Assert.assertEquals((long)1324L, (long)array.get(7L));
    }

    @Test
    public void shouldChunksAsNeeded() {
        IntArray array = NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newDynamicIntArray(10L, 0);
        long index = 243L;
        int value = 5485748;
        array.set(index, value);
        Assert.assertEquals((long)value, (long)array.get(index));
    }
}

