/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodeValueClientFilter
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private final IndexProgressor.NodeValueClient target;
    private final NodeCursor node;
    private final PropertyCursor property;
    private final IndexQuery[] filters;
    private final Read read;
    private IndexProgressor progressor;

    NodeValueClientFilter(IndexProgressor.NodeValueClient target, NodeCursor node, PropertyCursor property, Read read, IndexQuery ... filters) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.filters = filters;
        this.read = read;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues) {
        this.progressor = progressor;
        this.target.initialize(descriptor, (IndexProgressor)this, query, indexOrder, needsValues);
    }

    public boolean acceptNode(long reference, Value[] values) {
        int storeLookups = 0;
        if (values == null) {
            for (IndexQuery filter : this.filters) {
                if (filter == null) continue;
                ++storeLookups;
            }
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter = this.filters[i];
                if (filter == null) continue;
                if (values[i] == Values.NO_VALUE) {
                    ++storeLookups;
                    continue;
                }
                if (filter.acceptsValue(values[i])) continue;
                return false;
            }
        }
        if (storeLookups > 0 && !this.acceptByStoreFiltering(reference, storeLookups, values)) {
            return false;
        }
        return this.target.acceptNode(reference, values);
    }

    private boolean acceptByStoreFiltering(long reference, int storeLookups, Value[] values) {
        this.read.singleNode(reference, this.node);
        if (!this.node.next()) {
            this.property.close();
            return false;
        }
        this.node.properties(this.property);
        while (storeLookups > 0 && this.property.next()) {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter = this.filters[i];
                if (filter == null || values != null && values[i] != Values.NO_VALUE || this.property.propertyKey() != filter.propertyKeyId()) continue;
                if (!filter.acceptsValueAt(this.property)) {
                    return false;
                }
                --storeLookups;
            }
        }
        return storeLookups == 0;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        return this.progressor.next();
    }

    public void close() {
        IOUtils.close(RuntimeException::new, (AutoCloseable[])new AutoCloseable[]{this.node, this.property, this.progressor});
    }
}

