/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.helpers.Numbers;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.input.Group;

public interface GroupCache
extends AutoCloseable {
    public static final GroupCache GLOBAL = new GroupCache(){

        @Override
        public void set(long nodeId, int groupId) {
            assert (groupId == Group.GLOBAL.id());
        }

        @Override
        public int get(long nodeId) {
            return Group.GLOBAL.id();
        }

        @Override
        public void close() {
        }
    };

    public void set(long var1, int var3);

    public int get(long var1);

    @Override
    public void close();

    public static GroupCache select(NumberArrayFactory factory, int chunkSize, int numberOfGroups) {
        if (numberOfGroups == 0) {
            return GLOBAL;
        }
        if (numberOfGroups <= 256) {
            return new ByteGroupCache(factory, chunkSize);
        }
        if (numberOfGroups <= 65536) {
            return new ShortGroupCache(factory, chunkSize);
        }
        throw new IllegalArgumentException("Max allowed groups is 65535, but wanted " + numberOfGroups);
    }

    public static class ShortGroupCache
    implements GroupCache {
        private final ByteArray array;

        public ShortGroupCache(NumberArrayFactory factory, int chunkSize) {
            this.array = factory.newDynamicByteArray(chunkSize, new byte[2]);
        }

        @Override
        public void set(long nodeId, int groupId) {
            this.array.setShort(nodeId, 0, Numbers.safeCastIntToUnsignedShort((int)groupId));
        }

        @Override
        public int get(long nodeId) {
            return Numbers.unsignedShortToInt((short)this.array.getShort(nodeId, 0));
        }

        @Override
        public void close() {
            this.array.close();
        }
    }

    public static class ByteGroupCache
    implements GroupCache {
        private final ByteArray array;

        public ByteGroupCache(NumberArrayFactory factory, int chunkSize) {
            this.array = factory.newDynamicByteArray(chunkSize, new byte[1]);
        }

        @Override
        public void set(long nodeId, int groupId) {
            this.array.setByte(nodeId, 0, Numbers.safeCastIntToUnsignedByte((int)groupId));
        }

        @Override
        public int get(long nodeId) {
            return Numbers.unsignedByteToInt((byte)this.array.getByte(nodeId, 0));
        }

        @Override
        public void close() {
            this.array.close();
        }
    }
}

