/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DataSourceDiagnostics;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class NeoStoreDataSourceTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)this.fs.get());
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void databaseHealthShouldBeHealedOnStart() throws Throwable {
        NeoStoreDataSource theDataSource = null;
        try {
            DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(DatabaseHealth.class));
            Dependencies dependencies = new Dependencies();
            dependencies.satisfyDependency((Object)databaseHealth);
            theDataSource = this.dsRule.getDataSource(this.dir.databaseLayout(), this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()), (DependencyResolver)dependencies);
            databaseHealth.panic(new Throwable());
            theDataSource.start();
            databaseHealth.assertHealthy(Throwable.class);
        }
        finally {
            if (theDataSource != null) {
                theDataSource.stop();
                theDataSource.shutdown();
            }
        }
    }

    @Test
    public void flushOfThePageCacheHappensOnlyOnceDuringShutdown() throws Throwable {
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.databaseLayout(), this.fs.get(), pageCache);
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache)).flushAndForce(IOLimiter.UNLIMITED);
    }

    @Test
    public void flushOfThePageCacheOnShutdownHappensIfTheDbIsHealthy() throws Throwable {
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.databaseLayout(), this.fs.get(), pageCache);
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache)).flushAndForce(IOLimiter.UNLIMITED);
    }

    @Test
    public void flushOfThePageCacheOnShutdownDoesNotHappenIfTheDbIsUnhealthy() throws Throwable {
        DatabaseHealth health = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)health.isHealthy()).thenReturn((Object)false);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)health);
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.databaseLayout(), this.fs.get(), pageCache, (DependencyResolver)dependencies);
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForNoTransactionLogs() {
        NeoStoreDataSource dataSource = NeoStoreDataSourceTest.neoStoreDataSourceWithLogFilesContainingLowestTxId(NeoStoreDataSourceTest.noLogs());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        DataSourceDiagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.rawMessageMatcher().assertContains("No transactions");
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = NeoStoreDataSourceTest.neoStoreDataSourceWithLogFilesContainingLowestTxId(NeoStoreDataSourceTest.logWithTransactions(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        DataSourceDiagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.rawMessageMatcher().assertContains("transaction " + (prevLogLastTxId + 1L));
        logProvider.rawMessageMatcher().assertContains("version " + logVersion);
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInSecondOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = NeoStoreDataSourceTest.neoStoreDataSourceWithLogFilesContainingLowestTxId(NeoStoreDataSourceTest.logWithTransactionsInNextToOldestLog(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        DataSourceDiagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.rawMessageMatcher().assertContains("transaction " + (prevLogLastTxId + 1L));
        logProvider.rawMessageMatcher().assertContains("version " + (logVersion + 1L));
    }

    @Test
    public void logModuleSetUpError() {
        Config config = Config.defaults();
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        RuntimeException openStoresError = new RuntimeException("Can't set up modules");
        ((IdGeneratorFactory)Mockito.doThrow((Throwable[])new Throwable[]{openStoresError}).when((Object)idGeneratorFactory)).create((File)ArgumentMatchers.any(File.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        CommunityIdTypeConfigurationProvider idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{idGeneratorFactory, idTypeConfigurationProvider, config, logService});
        NeoStoreDataSource dataSource = this.dsRule.getDataSource(this.dir.databaseLayout(), this.fs.get(), pageCache, (DependencyResolver)dependencies);
        try {
            dataSource.start();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)openStoresError, (Object)e);
        }
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(NeoStoreDataSource.class).warn(Matchers.equalTo((Object)"Exception occurred while setting up store modules. Attempting to close things down."), Matchers.equalTo((Object)openStoresError))});
    }

    @Test
    public void shouldAlwaysShutdownLifeEvenWhenCheckPointingFails() throws Exception {
        FileSystemAbstraction fs = this.fs.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(fs);
        DatabaseHealth databaseHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)databaseHealth.isHealthy()).thenReturn((Object)true);
        IOException ex = new IOException("boom!");
        ((DatabaseHealth)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)databaseHealth)).assertHealthy(IOException.class);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{databaseHealth});
        NeoStoreDataSource dataSource = this.dsRule.getDataSource(this.dir.databaseLayout(), fs, pageCache, (DependencyResolver)dependencies);
        dataSource.start();
        try {
            dataSource.stop();
            Assert.fail((String)"it should have thrown");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }

    private static NeoStoreDataSource neoStoreDataSourceWithLogFilesContainingLowestTxId(LogFiles files) {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency(LogFiles.class)).thenReturn((Object)files);
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)resolver);
        return dataSource;
    }

    private static LogFiles noLogs() {
        LogFiles files = (LogFiles)Mockito.mock(TransactionLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)-1L);
        return files;
    }

    private static LogFiles logWithTransactions(long logVersion, long headerTxId) throws IOException {
        LogFiles files = (LogFiles)Mockito.mock(TransactionLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyEntries(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.extractHeader(logVersion)).thenReturn((Object)new LogHeader(LogEntryVersion.CURRENT.byteCode(), logVersion, headerTxId));
        return files;
    }

    private static LogFiles logWithTransactionsInNextToOldestLog(long logVersion, long prevLogLastTxId) throws IOException {
        LogFiles files = NeoStoreDataSourceTest.logWithTransactions(logVersion + 1L, prevLogLastTxId);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyEntries(logVersion)).thenReturn((Object)false);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        return files;
    }
}

