/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.Values;

class IndexConfigProviderTest {
    IndexConfigProviderTest() {
    }

    @Test
    void putAllNoOverwriteMustAddToSource() {
        HashMap<String, IntValue> target = new HashMap<String, IntValue>();
        HashMap<String, IntValue> source = new HashMap<String, IntValue>();
        target.put("a", Values.intValue((int)1));
        source.put("b", Values.intValue((int)2));
        IndexConfigProvider.putAllNoOverwrite(target, source);
        Assertions.assertEquals((int)2, (int)target.size());
        Assertions.assertEquals((Object)Values.intValue((int)1), target.get("a"));
        Assertions.assertEquals((Object)Values.intValue((int)2), target.get("b"));
        Assertions.assertEquals((int)1, (int)source.size());
        Assertions.assertEquals((Object)Values.intValue((int)2), source.get("b"));
    }

    @Test
    void putAllNoOverwriteMustThrowOnConflict() {
        HashMap<String, IntValue> target = new HashMap<String, IntValue>();
        HashMap<String, IntValue> source = new HashMap<String, IntValue>();
        target.put("a", Values.intValue((int)1));
        source.put("a", Values.intValue((int)2));
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> IndexConfigProvider.putAllNoOverwrite((Map)target, (Map)source));
        Assertions.assertEquals((Object)"Adding config would overwrite existing value: key=a, newValue=Int(2), oldValue=Int(1)", (Object)e.getMessage());
    }
}

