/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.kernel.impl.api.index.EntityCommandGrouper;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class EntityCommandGrouperTest {
    @Inject
    private RandomRule random;
    private long nextPropertyId;

    EntityCommandGrouperTest() {
    }

    @ParameterizedTest
    @EnumSource(value=Factory.class)
    void shouldHandleEmptyList(Factory factory) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(factory.command(0L).getClass(), 8);
        EntityCommandGrouper.Cursor cursor = grouper.sortAndAccessGroups();
        boolean hasNext = cursor.nextEntity();
        Assertions.assertFalse((boolean)hasNext);
    }

    @ParameterizedTest
    @EnumSource(value=Factory.class)
    void shouldSeeSingleGroupOfPropertiesWithEntity(Factory factory) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(factory.command(0L).getClass(), 8);
        long entityId = 1L;
        Command.BaseCommand<? extends PrimitiveRecord> entity = factory.command(entityId);
        Command.PropertyCommand property1 = this.property((PrimitiveRecord)entity.getAfter());
        Command.PropertyCommand property2 = this.property((PrimitiveRecord)entity.getAfter());
        grouper.add((Command)property1);
        grouper.add((Command)property2);
        grouper.add(entity);
        EntityCommandGrouper.Cursor cursor = grouper.sortAndAccessGroups();
        this.assertGroups(cursor, this.group(entityId, entity, property1, property2));
    }

    @ParameterizedTest
    @EnumSource(value=Factory.class)
    void shouldSeeSingleGroupOfPropertiesWithoutEntity(Factory factory) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(factory.command(0L).getClass(), 8);
        long entityId = 1L;
        Command.BaseCommand<? extends PrimitiveRecord> entity = factory.command(entityId);
        Command.PropertyCommand property1 = this.property((PrimitiveRecord)entity.getAfter());
        Command.PropertyCommand property2 = this.property((PrimitiveRecord)entity.getAfter());
        grouper.add((Command)property1);
        grouper.add((Command)property2);
        EntityCommandGrouper.Cursor cursor = grouper.sortAndAccessGroups();
        this.assertGroups(cursor, this.group(entityId, null, property1, property2));
    }

    @ParameterizedTest
    @EnumSource(value=Factory.class)
    void shouldSeeMultipleGroupsSomeOfThemWithEntity(Factory factory) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(factory.command(0L).getClass(), 64);
        Group[] groups = new Group[this.random.nextInt(10, 30)];
        for (int entityId = 0; entityId < groups.length; ++entityId) {
            Command.BaseCommand<? extends PrimitiveRecord> entityCommand = this.random.nextBoolean() ? factory.command(entityId) : null;
            groups[entityId] = new Group(entityId, (Command)entityCommand, new Command.PropertyCommand[0]);
            if (entityCommand == null) continue;
            grouper.add(entityCommand);
        }
        int totalNumberOfProperties = this.random.nextInt(10, 100);
        for (int i = 0; i < totalNumberOfProperties; ++i) {
            int entityId = this.random.nextInt(groups.length);
            Command.PropertyCommand property = this.property((PrimitiveRecord)factory.command(entityId).getAfter());
            groups[entityId].addProperty(property);
            grouper.add((Command)property);
        }
        EntityCommandGrouper.Cursor cursor = grouper.sortAndAccessGroups();
        this.assertGroups(cursor, groups);
    }

    @ParameterizedTest
    @EnumSource(value=Factory.class)
    void shouldWorkOnADifferentSetOfCommandsAfterClear(Factory factory) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(factory.command(0L).getClass(), 16);
        Command.BaseCommand<? extends PrimitiveRecord> entity0 = factory.command(0L);
        Command.BaseCommand<? extends PrimitiveRecord> entity1 = factory.command(1L);
        grouper.add(entity0);
        grouper.add(entity1);
        grouper.add((Command)this.property((PrimitiveRecord)entity0.getAfter()));
        grouper.add((Command)this.property((PrimitiveRecord)entity1.getAfter()));
        grouper.clear();
        Command.BaseCommand<? extends PrimitiveRecord> entity2 = factory.command(2L);
        Command.PropertyCommand entityProperty = this.property((PrimitiveRecord)entity2.getAfter());
        Command.BaseCommand<? extends PrimitiveRecord> entity3 = factory.command(3L);
        grouper.add(entity2);
        grouper.add((Command)entityProperty);
        grouper.add(entity3);
        this.assertGroups(grouper.sortAndAccessGroups(), this.group(entity2.getKey(), entity2, entityProperty), this.group(entity3.getKey(), entity3, new Command.PropertyCommand[0]));
    }

    private void assertGroups(EntityCommandGrouper.Cursor cursor, Group ... groups) {
        for (Group group : groups) {
            if (group.isEmpty()) continue;
            Assertions.assertTrue((boolean)cursor.nextEntity());
            group.assertGroup(cursor);
        }
        Assertions.assertFalse((boolean)cursor.nextEntity());
    }

    private Group group(long entityId, Command.BaseCommand<? extends PrimitiveRecord> entityCommand, Command.PropertyCommand ... properties) {
        return new Group(entityId, (Command)entityCommand, properties);
    }

    private Command.PropertyCommand property(PrimitiveRecord owner) {
        long propertyId = this.nextPropertyId++;
        return new Command.PropertyCommand(new PropertyRecord(propertyId, owner), new PropertyRecord(propertyId, owner));
    }

    private static enum Factory {
        NODE{

            Command.NodeCommand command(long value) {
                return new Command.NodeCommand(new NodeRecord(value), new NodeRecord(value));
            }
        }
        ,
        RELATIONSHIP{

            Command.RelationshipCommand command(long value) {
                return new Command.RelationshipCommand(new RelationshipRecord(value), new RelationshipRecord(value));
            }
        };


        abstract Command.BaseCommand<? extends PrimitiveRecord> command(long var1);
    }

    private static class Group {
        private final long entityId;
        private final Command entityCommand;
        private final Set<Command.PropertyCommand> properties = new HashSet<Command.PropertyCommand>();

        Group(long entityId, Command entityCommand, Command.PropertyCommand ... properties) {
            this.entityId = entityId;
            this.entityCommand = entityCommand;
            this.properties.addAll(Arrays.asList(properties));
        }

        void addProperty(Command.PropertyCommand property) {
            this.properties.add(property);
        }

        void assertGroup(EntityCommandGrouper.Cursor cursor) {
            Command.PropertyCommand property;
            Assertions.assertEquals((long)this.entityId, (long)cursor.currentEntityId());
            Assertions.assertSame((Object)this.entityCommand, (Object)cursor.currentEntityCommand());
            HashSet<Command.PropertyCommand> fromGrouper = new HashSet<Command.PropertyCommand>();
            while ((property = cursor.nextProperty()) != null) {
                fromGrouper.add(property);
            }
            Assertions.assertEquals(fromGrouper, this.properties);
        }

        boolean isEmpty() {
            return this.entityCommand == null && this.properties.isEmpty();
        }
    }
}

