/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

public class UpdatesTracker {
    private int created;
    private int updated;
    private int deleted;
    private int createdDuringPopulation;
    private int updatedDuringPopulation;
    private int deletedDuringPopulation;
    private boolean populationCompleted;

    public void increaseCreated(int num) {
        this.created += num;
    }

    public void increaseDeleted(int num) {
        this.deleted += num;
    }

    public void increaseUpdated(int num) {
        this.updated += num;
    }

    void notifyPopulationCompleted() {
        if (this.populationCompleted) {
            return;
        }
        this.populationCompleted = true;
        this.createdDuringPopulation = this.created;
        this.updatedDuringPopulation = this.updated;
        this.deletedDuringPopulation = this.deleted;
    }

    public boolean isPopulationCompleted() {
        return this.populationCompleted;
    }

    public int created() {
        return this.created;
    }

    public int deleted() {
        return this.deleted;
    }

    public int getUpdated() {
        return this.updated;
    }

    public int createdDuringPopulation() {
        return this.createdDuringPopulation;
    }

    public int deletedDuringPopulation() {
        return this.deletedDuringPopulation;
    }

    public int getUpdatedDuringPopulation() {
        return this.updatedDuringPopulation;
    }

    public int createdAfterPopulation() {
        return this.created - this.createdDuringPopulation;
    }

    public int deletedAfterPopulation() {
        return this.deleted - this.deletedDuringPopulation;
    }

    public int updatedAfterPopulation() {
        return this.updated - this.updatedDuringPopulation;
    }

    public void add(UpdatesTracker updatesTracker) {
        assert (this.isPopulationCompleted());
        assert (updatesTracker.isPopulationCompleted());
        this.created += updatesTracker.created;
        this.deleted += updatesTracker.deleted;
        this.updated += updatesTracker.updated;
        this.createdDuringPopulation += updatesTracker.createdDuringPopulation;
        this.updatedDuringPopulation += updatesTracker.updatedDuringPopulation;
        this.deletedDuringPopulation += updatesTracker.deletedDuringPopulation;
    }

    public String toString() {
        return "UpdatesTracker{created=" + this.created + ", deleted=" + this.deleted + ", createdDuringPopulation=" + this.createdDuringPopulation + ", updatedDuringPopulation=" + this.updatedDuringPopulation + ", deletedDuringPopulation=" + this.deletedDuringPopulation + ", createdAfterPopulation=" + this.createdAfterPopulation() + ", updatedAfterPopulation=" + this.updatedAfterPopulation() + ", deletedAfterPopulation=" + this.deletedAfterPopulation() + ", populationCompleted=" + this.populationCompleted + '}';
    }
}

