/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class JumpingFileSystemAbstraction
extends DelegatingFileSystemAbstraction {
    private final int sizePerJump;

    public JumpingFileSystemAbstraction(int sizePerJump) {
        this(new EphemeralFileSystemAbstraction(), sizePerJump);
    }

    private JumpingFileSystemAbstraction(EphemeralFileSystemAbstraction ephemeralFileSystem, int sizePerJump) {
        super((FileSystemAbstraction)ephemeralFileSystem);
        this.sizePerJump = sizePerJump;
    }

    public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
        StoreFileChannel channel = (StoreFileChannel)super.open(fileName, openMode);
        if (fileName.getName().equals("neostore.nodestore.db") || fileName.getName().equals("neostore.nodestore.db.labels") || fileName.getName().equals("neostore.relationshipstore.db") || fileName.getName().equals("neostore.propertystore.db") || fileName.getName().equals("neostore.propertystore.db.strings") || fileName.getName().equals("neostore.propertystore.db.arrays") || fileName.getName().equals("neostore.relationshipgroupstore.db")) {
            return new JumpingFileChannel(channel, this.recordSizeFor(fileName));
        }
        return channel;
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, OpenMode.READ_WRITE), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, OpenMode.READ));
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), charset);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.open(fileName, OpenMode.READ_WRITE);
    }

    public static int getRecordSize(int dataSize) {
        return dataSize + 8;
    }

    private int recordSizeFor(File fileName) {
        if (fileName.getName().endsWith("nodestore.db")) {
            return 15;
        }
        if (fileName.getName().endsWith("relationshipstore.db")) {
            return 34;
        }
        if (fileName.getName().endsWith("propertystore.db.strings") || fileName.getName().endsWith("propertystore.db.arrays")) {
            return JumpingFileSystemAbstraction.getRecordSize(120);
        }
        if (fileName.getName().endsWith("propertystore.db")) {
            return 41;
        }
        if (fileName.getName().endsWith("nodestore.db.labels")) {
            return Integer.parseInt(GraphDatabaseSettings.label_block_size.getDefaultValue()) + 8;
        }
        if (fileName.getName().endsWith("schemastore.db")) {
            return JumpingFileSystemAbstraction.getRecordSize(56);
        }
        if (fileName.getName().endsWith("relationshipgroupstore.db")) {
            return JumpingFileSystemAbstraction.getRecordSize(25);
        }
        throw new IllegalArgumentException(fileName.getPath());
    }

    public class JumpingFileChannel
    extends StoreFileChannel {
        private final int recordSize;

        JumpingFileChannel(StoreFileChannel actual, int recordSize) {
            super(actual);
            this.recordSize = recordSize;
        }

        private long translateIncoming(long position) {
            return this.translateIncoming(position, false);
        }

        private long translateIncoming(long position, boolean allowFix) {
            long actualRecord = position / (long)this.recordSize;
            if (actualRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return position;
            }
            long jumpIndex = (actualRecord + (long)JumpingFileSystemAbstraction.this.sizePerJump) / 0x100000000L;
            long diff = actualRecord - jumpIndex * 0x100000000L;
            diff = this.assertWithinDiff(diff, allowFix);
            long offsetRecord = jumpIndex * (long)JumpingFileSystemAbstraction.this.sizePerJump + diff;
            return offsetRecord * (long)this.recordSize;
        }

        private long translateOutgoing(long offsetPosition) {
            long offsetRecord = offsetPosition / (long)this.recordSize;
            if (offsetRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return offsetPosition;
            }
            long jumpIndex = (offsetRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) / (long)JumpingFileSystemAbstraction.this.sizePerJump + 1L;
            long diff = (offsetRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) % (long)JumpingFileSystemAbstraction.this.sizePerJump - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2);
            this.assertWithinDiff(diff, false);
            long actualRecord = jumpIndex * 0x100000000L - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2) + diff;
            return actualRecord * (long)this.recordSize;
        }

        private long assertWithinDiff(long diff, boolean allowFix) {
            if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2) || diff > (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                if (allowFix) {
                    if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                        return -JumpingFileSystemAbstraction.this.sizePerJump / 2;
                    }
                    return JumpingFileSystemAbstraction.this.sizePerJump / 2;
                }
                throw new IllegalArgumentException("" + diff);
            }
            return diff;
        }

        public long position() throws IOException {
            return this.translateOutgoing(super.position());
        }

        public JumpingFileChannel position(long newPosition) throws IOException {
            super.position(this.translateIncoming(newPosition));
            return this;
        }

        public long size() throws IOException {
            return this.translateOutgoing(super.size());
        }

        public JumpingFileChannel truncate(long size) throws IOException {
            super.truncate(this.translateIncoming(size, true));
            return this;
        }

        public int read(ByteBuffer dst, long position) throws IOException {
            return super.read(dst, this.translateIncoming(position));
        }
    }
}

