/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialNonUniqueIndexPopulatorTest
extends NativeIndexPopulatorTests.NonUnique<SpatialIndexKey, NativeIndexValue> {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
    private SpatialIndexFiles.SpatialFile spatialFile;

    @Override
    NativeIndexPopulator<SpatialIndexKey, NativeIndexValue> createPopulator() {
        this.spatialFile = new SpatialIndexFiles.SpatialFile(crs, configuredSettings, super.getIndexFile());
        return new SpatialIndexPopulator.PartPopulator(this.pageCache, (FileSystemAbstraction)this.fs, this.spatialFile.getLayoutForNewIndex(), this.monitor, this.indexDescriptor, (SpaceFillingCurveConfiguration)new StandardConfiguration());
    }

    @Override
    public File getIndexFile() {
        return this.spatialFile.indexFile;
    }

    @Override
    protected ValueCreatorUtil<SpatialIndexKey, NativeIndexValue> createValueCreatorUtil() {
        return new SpatialValueCreatorUtil(TestIndexDescriptorFactory.forLabel(42, 666).withId(0L), 0.1);
    }

    @Override
    IndexLayout<SpatialIndexKey, NativeIndexValue> createLayout() {
        return new SpatialLayout(crs, configuredSettings.forCRS(crs).curve());
    }
}

