/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;

public class ConfigurableStandalonePageCacheFactoryTest {
    @Rule
    public VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(30L, TimeUnit.SECONDS).build();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void mustAutomaticallyStartEvictionThread() throws Exception {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            File file = new File(this.testDirectory.directory(), "a").getCanonicalFile();
            fs.create(file).close();
            try (PageCache cache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler);
                 PagedFile pf = cache.map(file, 4096, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                for (int i = 0; i < 10000; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                    cursor.putInt(42);
                }
            }
        }
    }
}

