/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageSwapperFactoryForTesting;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ConfiguringPageCacheFactoryTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private JobScheduler jobScheduler;

    @Before
    public void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        PageSwapperFactoryForTesting.createdCounter.set(0);
        PageSwapperFactoryForTesting.configuredCounter.set(0);
    }

    @After
    public void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    public void shouldFitAsManyPagesAsItCan() {
        long pageCount = 60L;
        long memory = MuninnPageCache.memoryRequiredForPages((long)pageCount);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)Long.toString(memory));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)8192));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)pageCount));
        }
    }

    @Test
    public void shouldWarnWhenCreatedWithConfiguredPageCache() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"}));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, log, EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        try (PageCache ignore = pageCacheFactory.getOrCreatePageCache();){
            logProvider.rawMessageMatcher().assertContains("The setting unsupported.dbms.memory.pagecache.pagesize does not have any effect. It is deprecated and will be removed in a future version.");
        }
    }

    @Test
    public void mustUseAndLogConfiguredPageSwapper() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"}));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(PageCache.class);
        ConfiguringPageCacheFactory cacheFactory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, log, EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        cacheFactory.getOrCreatePageCache().close();
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countCreatedPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countConfiguredPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        logProvider.rawMessageMatcher().assertContains("pageSwapperForTesting");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowIfConfiguredPageSwapperCannotBeFound() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.pagecache_swapper.name(), "non-existing"}));
        new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler).getOrCreatePageCache().close();
    }
}

