/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CommonAbstractStoreBehaviourTest {
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8M");
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final ConfigurablePageCacheRule pageCacheRule = new ConfigurablePageCacheRule();
    @Rule
    public final TestRule rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.pageCacheRule);
    private final Queue<Long> nextPageId = new ConcurrentLinkedQueue<Long>();
    private final Queue<Integer> nextPageOffset = new ConcurrentLinkedQueue<Integer>();
    private int cursorErrorOnRecord;
    private int intsPerRecord = 1;
    private MyStore store;
    private Config config = CONFIG;

    @After
    public void tearDown() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.nextPageOffset.clear();
        this.nextPageId.clear();
    }

    private void assertThrowsUnderlyingStorageException(ThrowingAction<Exception> action) throws Exception {
        try {
            action.apply();
            Assert.fail((String)"expected an UnderlyingStorageException exception");
        }
        catch (UnderlyingStorageException underlyingStorageException) {
            // empty catch block
        }
    }

    private void assertThrowsInvalidRecordException(ThrowingAction<Exception> action) throws Exception {
        try {
            action.apply();
            Assert.fail((String)"expected an InvalidRecordException exception");
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
    }

    private void verifyExceptionOnOutOfBoundsAccess(ThrowingAction<Exception> access) throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.assertThrowsUnderlyingStorageException(access);
    }

    private void prepareStoreForOutOfBoundsAccess() {
        this.createStore();
        this.nextPageOffset.add(8190);
    }

    private void verifyExceptionOnCursorError(ThrowingAction<Exception> access) throws Exception {
        this.prepareStoreForCursorError();
        this.assertThrowsInvalidRecordException(access);
    }

    private void prepareStoreForCursorError() {
        this.createStore();
        this.cursorErrorOnRecord = 5;
    }

    private void createStore() {
        this.store = new MyStore(this.config, this.pageCacheRule.getPageCache(this.fs.get(), this.config), 8);
        this.store.initialise(true);
    }

    @Test
    public void writingOfHeaderRecordDuringInitialiseNewStoreFileMustThrowOnPageOverflow() throws Exception {
        PageCacheRule.PageCacheConfig pageCacheConfig = PageCacheRule.config();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get(), pageCacheConfig, this.config);
        MyStore store = new MyStore(this.config, pageCache, 8193);
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> store.initialise(true)));
    }

    @Test
    public void extractHeaderRecordDuringLoadStorageMustThrowOnPageOverflow() throws Exception {
        MyStore first = new MyStore(this.config, this.pageCacheRule.getPageCache(this.fs.get(), this.config), 8);
        first.initialise(true);
        first.close();
        PageCacheRule.PageCacheConfig pageCacheConfig = PageCacheRule.config();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get(), pageCacheConfig, this.config);
        MyStore second = new MyStore(this.config, pageCache, 8193);
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> second.initialise(false)));
    }

    @Test
    public void getRawRecordDataMustNotThrowOnPageOverflow() throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRawRecordData(5L);
    }

    @Test
    public void isInUseMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.isInUse(5L)));
    }

    @Test
    public void isInUseMustThrowOnCursorError() throws Exception {
        this.verifyExceptionOnCursorError((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.isInUse(5L)));
    }

    @Test
    public void getRecordMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> {
            IntRecord cfr_ignored_0 = (IntRecord)this.store.getRecord(5L, new IntRecord(5L), RecordLoad.NORMAL);
        }));
    }

    @Test
    public void getRecordMustNotThrowOnPageOverflowWithCheckLoadMode() {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.CHECK);
    }

    @Test
    public void getRecordMustNotThrowOnPageOverflowWithForceLoadMode() {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.FORCE);
    }

    @Test
    public void updateRecordMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.updateRecord(new IntRecord(5L))));
    }

    @Test
    public void getRecordMustThrowOnCursorError() throws Exception {
        this.verifyExceptionOnCursorError((ThrowingAction<Exception>)((ThrowingAction)() -> {
            IntRecord cfr_ignored_0 = (IntRecord)this.store.getRecord(5L, new IntRecord(5L), RecordLoad.NORMAL);
        }));
    }

    @Test
    public void getRecordMustNotThrowOnCursorErrorWithCheckLoadMode() {
        this.prepareStoreForCursorError();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.CHECK);
    }

    @Test
    public void getRecordMustNotThrowOnCursorErrorWithForceLoadMode() {
        this.prepareStoreForCursorError();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.FORCE);
    }

    @Test
    public void rebuildIdGeneratorSlowMustThrowOnPageOverflow() throws Exception {
        this.config.augment(GraphDatabaseSettings.rebuild_idgenerators_fast, "false");
        this.createStore();
        this.store.setStoreNotOk(new RuntimeException());
        IntRecord record = new IntRecord(200L);
        record.value = -889275714;
        this.store.updateRecord(record);
        this.intsPerRecord = 8192;
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.makeStoreOk()));
    }

    @Test
    public void scanForHighIdMustThrowOnPageOverflow() throws Exception {
        this.createStore();
        this.store.setStoreNotOk(new RuntimeException());
        IntRecord record = new IntRecord(200L);
        record.value = -889275714;
        this.store.updateRecord(record);
        this.intsPerRecord = 8192;
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.makeStoreOk()));
    }

    @Test
    public void mustFinishInitialisationOfIncompleteStoreHeader() throws IOException {
        this.createStore();
        int headerSizeInRecords = this.store.getNumberOfReservedLowIds();
        int headerSizeInBytes = headerSizeInRecords * this.store.getRecordSize();
        try (PageCursor cursor = this.store.pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            for (int i = 0; i < headerSizeInBytes; ++i) {
                cursor.putByte((byte)0);
            }
        }
        int pageSize = this.store.pagedFile.pageSize();
        this.store.close();
        this.store.pageCache.map(this.store.getStorageFile(), pageSize, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING}).close();
        this.createStore();
    }

    private class MyStore
    extends CommonAbstractStore<IntRecord, LongLongHeader> {
        MyStore(Config config, PageCache pageCache, int recordHeaderSize) {
            this(config, pageCache, commonAbstractStoreBehaviourTest.new MyFormat(recordHeaderSize));
        }

        MyStore(Config config, PageCache pageCache, MyFormat format) {
            super(new File("store"), new File("idFile"), config, IdType.NODE, (IdGeneratorFactory)new DefaultIdGeneratorFactory(CommonAbstractStoreBehaviourTest.this.fs.get()), pageCache, (LogProvider)NullLogProvider.getInstance(), "T", (RecordFormat)format, (StoreHeaderFormat)format, "XYZ", new OpenOption[0]);
        }

        public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, IntRecord record) {
            throw new UnsupportedOperationException();
        }

        protected long pageIdForRecord(long id) {
            Long override = (Long)CommonAbstractStoreBehaviourTest.this.nextPageId.poll();
            return override != null ? override.longValue() : super.pageIdForRecord(id);
        }

        protected int offsetForId(long id) {
            Integer override = (Integer)CommonAbstractStoreBehaviourTest.this.nextPageOffset.poll();
            return override != null ? override.intValue() : super.offsetForId(id);
        }
    }

    private class MyFormat
    extends BaseRecordFormat<IntRecord>
    implements StoreHeaderFormat<LongLongHeader> {
        MyFormat(int recordHeaderSize) {
            super(x -> 4, recordHeaderSize, 32);
        }

        public IntRecord newRecord() {
            return new IntRecord(0L);
        }

        public boolean isInUse(PageCursor cursor) {
            int offset = cursor.getOffset();
            long pageId = cursor.getCurrentPageId();
            long recordId = ((long)offset + pageId * (long)cursor.getCurrentPageSize()) / 4L;
            boolean inUse = false;
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                inUse |= cursor.getInt() != 0;
            }
            this.maybeSetCursorError(cursor, recordId);
            return inUse;
        }

        public void read(IntRecord record, PageCursor cursor, RecordLoad mode, int recordSize) {
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                record.value = cursor.getInt();
            }
            record.setInUse(true);
            this.maybeSetCursorError(cursor, record.getId());
        }

        private void maybeSetCursorError(PageCursor cursor, long id) {
            if ((long)CommonAbstractStoreBehaviourTest.this.cursorErrorOnRecord == id) {
                cursor.setCursorException("boom");
            }
        }

        public void write(IntRecord record, PageCursor cursor, int recordSize) {
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                cursor.putInt(record.value);
            }
        }

        public int numberOfReservedRecords() {
            return 4;
        }

        public void writeHeader(PageCursor cursor) {
            for (int i = 0; i < this.getRecordHeaderSize(); ++i) {
                cursor.putByte((byte)ThreadLocalRandom.current().nextInt());
            }
        }

        public LongLongHeader readHeader(PageCursor cursor) {
            LongLongHeader header = new LongLongHeader();
            for (int i = 0; i < this.getRecordHeaderSize(); ++i) {
                cursor.getByte();
            }
            return header;
        }
    }

    private static class LongLongHeader
    implements StoreHeader {
        private LongLongHeader() {
        }
    }

    private static class IntRecord
    extends AbstractBaseRecord {
        public int value;

        IntRecord(long id) {
            super(id);
            this.setInUse(true);
        }

        public String toString() {
            return "IntRecord[" + this.getId() + "](" + this.value + ")";
        }
    }
}

