/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.FakeClock;

public class FakeClockJobScheduler
extends FakeClock
implements JobScheduler {
    private final AtomicLong jobIdGen = new AtomicLong();
    private final Collection<JobHandle> jobs = new CopyOnWriteArrayList<JobHandle>();

    private JobHandle schedule(Runnable job, long firstDeadline) {
        JobHandle jobHandle = new JobHandle(job, firstDeadline, 0L);
        this.jobs.add(jobHandle);
        return jobHandle;
    }

    private JobHandle scheduleRecurring(Runnable job, long firstDeadline, long period) {
        JobHandle jobHandle = new JobHandle(job, firstDeadline, period);
        this.jobs.add(jobHandle);
        return jobHandle;
    }

    public FakeClock forward(long delta, TimeUnit unit) {
        super.forward(delta, unit);
        this.processSchedule();
        return this;
    }

    private void processSchedule() {
        boolean anyTriggered;
        do {
            anyTriggered = false;
            for (JobHandle job : this.jobs) {
                if (!job.tryTrigger()) continue;
                anyTriggered = true;
            }
        } while (anyTriggered);
    }

    private long now() {
        return this.instant().toEpochMilli();
    }

    public void setTopLevelGroupName(String name) {
    }

    public Executor executor(Group group) {
        return job -> this.schedule(job, this.now());
    }

    public ExecutorService workStealingExecutor(Group group, int parallelism) {
        throw new UnsupportedOperationException();
    }

    public ExecutorService workStealingExecutorAsyncMode(Group group, int parallelism) {
        throw new UnsupportedOperationException();
    }

    public ThreadFactory threadFactory(Group group) {
        throw new UnsupportedOperationException();
    }

    public JobHandle schedule(Group group, Runnable job) {
        JobHandle handle = this.schedule(job, this.now());
        this.processSchedule();
        return handle;
    }

    public JobHandle schedule(Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        JobHandle handle = this.schedule(job, this.now() + timeUnit.toMillis(initialDelay));
        if (initialDelay <= 0L) {
            this.processSchedule();
        }
        return handle;
    }

    public JobHandle scheduleRecurring(Group group, Runnable job, long period, TimeUnit timeUnit) {
        JobHandle handle = this.scheduleRecurring(job, this.now(), timeUnit.toMillis(period));
        this.processSchedule();
        return handle;
    }

    public JobHandle scheduleRecurring(Group group, Runnable job, long initialDelay, long period, TimeUnit timeUnit) {
        JobHandle handle = this.scheduleRecurring(job, this.now() + timeUnit.toMillis(initialDelay), timeUnit.toMillis(period));
        if (initialDelay <= 0L) {
            this.processSchedule();
        }
        return handle;
    }

    public void init() {
        throw new UnsupportedOperationException();
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.shutdown();
    }

    class JobHandle
    implements org.neo4j.scheduler.JobHandle {
        private final long id;
        private final Runnable runnable;
        private final long period;
        private long deadline;

        JobHandle(Runnable runnable, long firstDeadline, long period) {
            this.id = FakeClockJobScheduler.this.jobIdGen.incrementAndGet();
            this.runnable = runnable;
            this.deadline = firstDeadline;
            this.period = period;
        }

        boolean tryTrigger() {
            if (FakeClockJobScheduler.this.now() >= this.deadline) {
                this.runnable.run();
                if (this.period != 0L) {
                    this.deadline += this.period;
                } else {
                    FakeClockJobScheduler.this.jobs.remove(this);
                }
                return true;
            }
            return false;
        }

        public void cancel(boolean mayInterruptIfRunning) {
            FakeClockJobScheduler.this.jobs.remove(this);
        }

        public void waitTermination() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobHandle jobHandle = (JobHandle)o;
            return this.id == jobHandle.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

