/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.internal.dragons.NativeMemoryAllocationRefusedError;

public class NumberArrayFactoryTest {
    private static final long KILO = 1024L;

    @Test
    public void shouldPickFirstAvailableCandidateLongArray() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L);
        array.set(1014L, 12345L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldPickFirstAvailableCandidateLongArrayWhenSomeDontHaveEnoughMemory() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactory.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L);
        array.set(1014L, 12345L);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newLongArray(1024L, -1L, 0L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldThrowOomOnNotEnoughMemory() {
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{lowMemoryFactory});
        try {
            factory.newLongArray(1024L, -1L);
            Assert.fail((String)"Should have thrown");
        }
        catch (OutOfMemoryError e) {
            Assert.assertFalse((boolean)monitor.called);
        }
    }

    @Test
    public void shouldPickFirstAvailableCandidateIntArray() {
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        IntArray array = factory.newIntArray(1024L, -1);
        array.set(1014L, 12345);
        Assert.assertTrue((boolean)(array instanceof HeapIntArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
        Assert.assertEquals((Object)NumberArrayFactory.HEAP, (Object)monitor.successfulFactory);
        Assert.assertFalse((boolean)monitor.attemptedAllocationFailures.iterator().hasNext());
    }

    @Test
    public void shouldPickFirstAvailableCandidateIntArrayWhenSomeThrowOutOfMemoryError() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newIntArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactory.HEAP});
        IntArray array = factory.newIntArray(1024L, -1);
        array.set(1014L, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newIntArray(1024L, -1, 0L);
        Assert.assertTrue((boolean)(array instanceof HeapIntArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldPickFirstAvailableCandidateIntArrayWhenSomeThrowNativeMemoryAllocationRefusedError() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(NativeMemoryAllocationRefusedError.class).when((Object)lowMemoryFactory)).newIntArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactory.HEAP});
        IntArray array = factory.newIntArray(1024L, -1);
        array.set(1014L, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newIntArray(1024L, -1, 0L);
        Assert.assertTrue((boolean)(array instanceof HeapIntArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldCatchArithmeticExceptionsAndTryNext() {
        NumberArrayFactory throwingMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ArithmeticException failure = new ArithmeticException("This is an artificial failure");
        ((NumberArrayFactory)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)throwingMemoryFactory)).newByteArray(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyLong());
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{throwingMemoryFactory, NumberArrayFactory.HEAP});
        int itemSize = 4;
        ByteArray array = factory.newByteArray(1024L, new byte[itemSize], 0L);
        array.setInt(1014L, 0, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)throwingMemoryFactory, (VerificationMode)Mockito.times((int)1))).newByteArray(ArgumentMatchers.eq((long)1024L), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((long)0L));
        Assert.assertTrue((boolean)(array instanceof HeapByteArray));
        Assert.assertEquals((long)12345L, (long)array.getInt(1014L, 0));
        Assert.assertEquals((long)(1024L * (long)itemSize), (long)monitor.memory);
        Assert.assertEquals((Object)NumberArrayFactory.HEAP, (Object)monitor.successfulFactory);
        Assert.assertEquals((Object)throwingMemoryFactory, (Object)((NumberArrayFactory.AllocationFailure)Iterables.single((Iterable)monitor.attemptedAllocationFailures)).getFactory());
        Assert.assertThat((Object)((NumberArrayFactory.AllocationFailure)Iterables.single((Iterable)monitor.attemptedAllocationFailures)).getFailure().getMessage(), (Matcher)Matchers.containsString((String)failure.getMessage()));
    }

    @Test
    public void heapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        this.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    @Test
    public void offHeapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(NumberArrayFactory.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactory.OFF_HEAP});
        this.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    private void verifyVeryLargeBaseSupport(NumberArrayFactory factory) {
        long base = 2871185636039L;
        byte[] into = new byte[]{1};
        factory.newByteArray(10L, new byte[1], base).get(base + 1L, into);
        Assert.assertThat((Object)into[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)factory.newIntArray(10L, 1, base).get(base + 1L), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)factory.newLongArray(10L, 1L, base).get(base + 1L), (Matcher)Matchers.is((Object)1L));
    }

    private static class FailureMonitor
    implements NumberArrayFactory.Monitor {
        private boolean called;
        private long memory;
        private NumberArrayFactory successfulFactory;
        private Iterable<NumberArrayFactory.AllocationFailure> attemptedAllocationFailures;

        private FailureMonitor() {
        }

        public void allocationSuccessful(long memory, NumberArrayFactory successfulFactory, Iterable<NumberArrayFactory.AllocationFailure> attemptedAllocationFailures) {
            this.memory = memory;
            this.successfulFactory = successfulFactory;
            this.attemptedAllocationFailures = attemptedAllocationFailures;
            this.called = true;
        }
    }
}

