/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionState;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateCloseException;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateHolder;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateManager;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateProvider;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.storageengine.api.StorageCommand;

public class KernelAuxTransactionStateManager
implements AuxiliaryTransactionStateManager {
    private volatile CopyOnWriteHashMap<Object, AuxiliaryTransactionStateProvider> providers = new CopyOnWriteHashMap();

    @Override
    public void registerProvider(AuxiliaryTransactionStateProvider provider) {
        this.providers.put(provider.getIdentityKey(), provider);
    }

    @Override
    public void unregisterProvider(AuxiliaryTransactionStateProvider provider) {
        this.providers.remove(provider.getIdentityKey());
    }

    @Override
    public AuxiliaryTransactionStateHolder openStateHolder() {
        return new AuxStateHolder(this.providers.snapshot());
    }

    private static class AuxStateHolder
    implements AuxiliaryTransactionStateHolder,
    Function<Object, AuxiliaryTransactionState> {
        private final Map<Object, AuxiliaryTransactionStateProvider> providers;
        private final Map<Object, AuxiliaryTransactionState> openedStates;

        AuxStateHolder(Map<Object, AuxiliaryTransactionStateProvider> providers) {
            this.providers = providers;
            this.openedStates = new HashMap<Object, AuxiliaryTransactionState>();
        }

        @Override
        public AuxiliaryTransactionState getState(Object providerIdentityKey) {
            return this.openedStates.computeIfAbsent(providerIdentityKey, this);
        }

        @Override
        public AuxiliaryTransactionState apply(Object providerIdentityKey) {
            AuxiliaryTransactionStateProvider provider = this.providers.get(providerIdentityKey);
            if (provider != null) {
                return provider.createNewAuxiliaryTransactionState();
            }
            return null;
        }

        @Override
        public boolean hasChanges() {
            if (this.openedStates.isEmpty()) {
                return false;
            }
            for (AuxiliaryTransactionState state : this.openedStates.values()) {
                if (!state.hasChanges()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void extractCommands(Collection<StorageCommand> extractedCommands) throws TransactionFailureException {
            for (AuxiliaryTransactionState state : this.openedStates.values()) {
                if (!state.hasChanges()) continue;
                state.extractCommands(extractedCommands);
            }
        }

        @Override
        public void close() throws AuxiliaryTransactionStateCloseException {
            IOUtils.close((msg, cause) -> new AuxiliaryTransactionStateCloseException("Failure when closing auxiliary transaction state.", (Throwable)cause), this.openedStates.values());
        }
    }
}

