/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NumberLayout;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.NumberLayoutUnique;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class NumberIndexProvider
extends NativeIndexProvider<NumberIndexKey, NativeIndexValue, NumberLayout> {
    public static final String KEY = "native";
    public static final IndexProviderDescriptor NATIVE_PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("native", "1.0");
    static final IndexCapability CAPABILITY = new NumberIndexCapability();

    public NumberIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(NATIVE_PROVIDER_DESCRIPTOR, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    NumberLayout layout(StoreIndexDescriptor descriptor, File storeFile) {
        switch (descriptor.type()) {
            case GENERAL: {
                return new NumberLayoutNonUnique();
            }
            case UNIQUE: {
                return new NumberLayoutUnique();
            }
        }
        throw new IllegalArgumentException("Unknown index type " + descriptor.type());
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, NumberLayout layout, StoreIndexDescriptor descriptor, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
        return new WorkSyncedNativeIndexPopulator<NumberIndexKey, NativeIndexValue>(new NumberIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, tokenNameLookup));
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, NumberLayout layout, StoreIndexDescriptor descriptor, boolean readOnly, TokenNameLookup tokenNameLookup) {
        return new NumberIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, readOnly, tokenNameLookup);
    }

    @Override
    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return CAPABILITY;
    }

    private static class NumberIndexCapability
    implements IndexCapability {
        private NumberIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return ORDER_BOTH;
            }
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueCategories)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        public boolean isFulltextIndex() {
            return false;
        }

        public boolean isEventuallyConsistent() {
            return false;
        }

        private boolean support(ValueCategory[] valueCategories) {
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.NUMBER;
        }
    }
}

