/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.state.AppendOnlyValuesContainer;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.kernel.impl.api.state.ValuesMap;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.LinearProbeLongLongHashMap;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.MutableLinearProbeLongHashSet;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapMemoryAllocator;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class OffHeapCollectionsFactory
implements CollectionsFactory {
    private final MemoryAllocationTracker memoryTracker = new LocalMemoryTracker();
    private final MemoryAllocator allocator;
    private final Collection<Resource> resources = new ArrayList<Resource>();
    private ValuesContainer valuesContainer;

    public OffHeapCollectionsFactory(OffHeapBlockAllocator blockAllocator) {
        this.allocator = new OffHeapMemoryAllocator(this.memoryTracker, blockAllocator);
    }

    @Override
    public MutableLongSet newLongSet() {
        MutableLinearProbeLongHashSet set = new MutableLinearProbeLongHashSet(this.allocator);
        this.resources.add(set);
        return set;
    }

    @Override
    public MutableLongDiffSetsImpl newLongDiffSets() {
        return new MutableLongDiffSetsImpl(this);
    }

    @Override
    public MutableLongObjectMap<Value> newValuesMap() {
        if (this.valuesContainer == null) {
            this.valuesContainer = new AppendOnlyValuesContainer(this.allocator);
        }
        LinearProbeLongLongHashMap refs = new LinearProbeLongLongHashMap(this.allocator);
        this.resources.add(refs);
        return new ValuesMap(refs, this.valuesContainer);
    }

    @Override
    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    @Override
    public void release() {
        this.resources.forEach(Resource::close);
        this.resources.clear();
        if (this.valuesContainer != null) {
            this.valuesContainer.close();
            this.valuesContainer = null;
        }
    }
}

