/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.io.PrintStream;
import org.neo4j.kernel.extension.FailedToBuildKernelExtensionException;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensionFailureStrategy;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class KernelExtensionFailureStrategies {
    private KernelExtensionFailureStrategies() {
    }

    private static FailedToBuildKernelExtensionException wrap(KernelExtensionFactory kernelExtensionFactory, UnsatisfiedDependencyException e) {
        return new FailedToBuildKernelExtensionException("Failed to build kernel extension " + kernelExtensionFactory + " due to a missing dependency: " + e.getMessage(), e);
    }

    private static FailedToBuildKernelExtensionException wrap(KernelExtensionFactory kernelExtensionFactory, Throwable e) {
        StringBuilder message = new StringBuilder("Failed to build kernel extension ").append(kernelExtensionFactory);
        if (e instanceof LinkageError || e instanceof ReflectiveOperationException) {
            if (e instanceof LinkageError) {
                message.append(" because it is compiled with a reference to a class, method, or field, that is not in the class path: ");
            } else {
                message.append(" because it a reflective access to a class, method, or field, that is not in the class path: ");
            }
            message.append('\'').append(e.getMessage()).append('\'');
            message.append(". The most common cause of this problem, is that Neo4j has been upgraded without also upgrading all");
            message.append("installed extensions, such as APOC. ");
            message.append("Make sure that all of your extensions are build against your specific version of Neo4j.");
        } else {
            message.append(" because of an unanticipated error: '").append(e.getMessage()).append("'.");
        }
        return new FailedToBuildKernelExtensionException(message.toString(), e);
    }

    public static KernelExtensionFailureStrategy fail() {
        return new KernelExtensionFailureStrategy(){

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, UnsatisfiedDependencyException e) {
                throw KernelExtensionFailureStrategies.wrap(kernelExtensionFactory, e);
            }

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, Throwable e) {
                throw KernelExtensionFailureStrategies.wrap(kernelExtensionFactory, e);
            }
        };
    }

    public static KernelExtensionFailureStrategy ignore() {
        return new KernelExtensionFailureStrategy(){

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, UnsatisfiedDependencyException e) {
            }

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, Throwable e) {
            }
        };
    }

    public static KernelExtensionFailureStrategy print(final PrintStream out) {
        return new KernelExtensionFailureStrategy(){

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, UnsatisfiedDependencyException e) {
                KernelExtensionFailureStrategies.wrap(kernelExtensionFactory, e).printStackTrace(out);
            }

            @Override
            public void handle(KernelExtensionFactory kernelExtensionFactory, Throwable e) {
                KernelExtensionFailureStrategies.wrap(kernelExtensionFactory, e).printStackTrace(out);
            }
        };
    }
}

