/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.SimpleLongLayout;
import org.neo4j.kernel.impl.index.schema.CombinedPartSeeker;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class CombinedPartSeekerTest {
    private static final Comparator<Hit<MutableLong, MutableLong>> HIT_COMPARATOR = Comparator.comparing(Hit::key);
    @Inject
    RandomRule random;

    CombinedPartSeekerTest() {
    }

    @Test
    void shouldCombineAllParts() throws IOException {
        SimpleLongLayout layout = new SimpleLongLayout(0, "", true, 1, 2, 3);
        ArrayList<SimpleSeeker> parts = new ArrayList<SimpleSeeker>();
        int partCount = this.random.nextInt(1, 20);
        ArrayList<Object> expectedAllData = new ArrayList<Object>();
        int maxKey = this.random.nextInt(100, 10000);
        for (int i = 0; i < partCount; ++i) {
            int dataSize = this.random.nextInt(0, 100);
            ArrayList<SimpleHit<MutableLong, MutableLong>> arrayList = new ArrayList<SimpleHit<MutableLong, MutableLong>>(dataSize);
            for (int j = 0; j < dataSize; ++j) {
                long key = this.random.nextLong((long)maxKey);
                arrayList.add(new SimpleHit<MutableLong, MutableLong>(new MutableLong(key), new MutableLong(key * 2L)));
            }
            arrayList.sort(HIT_COMPARATOR);
            parts.add(new SimpleSeeker(arrayList));
            expectedAllData.addAll(arrayList);
        }
        expectedAllData.sort(HIT_COMPARATOR);
        CombinedPartSeeker combinedSeeker = new CombinedPartSeeker((Layout)layout, parts);
        for (Hit hit : expectedAllData) {
            Assert.assertTrue((boolean)combinedSeeker.next());
            Hit actualHit = combinedSeeker.get();
            Assert.assertEquals((long)((MutableLong)hit.key()).longValue(), (long)((MutableLong)actualHit.key()).longValue());
            Assert.assertEquals((long)((MutableLong)hit.value()).longValue(), (long)((MutableLong)actualHit.value()).longValue());
        }
        Assert.assertFalse((boolean)combinedSeeker.next());
        Assert.assertFalse((boolean)combinedSeeker.next());
    }

    private static class SimpleSeeker
    implements RawCursor<Hit<MutableLong, MutableLong>, IOException> {
        private final Iterator<Hit<MutableLong, MutableLong>> data;
        private Hit<MutableLong, MutableLong> current;

        private SimpleSeeker(Iterable<Hit<MutableLong, MutableLong>> data) {
            this.data = data.iterator();
        }

        public boolean next() {
            if (this.data.hasNext()) {
                this.current = this.data.next();
                return true;
            }
            return false;
        }

        public void close() {
        }

        public Hit<MutableLong, MutableLong> get() {
            return this.current;
        }
    }
}

