/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class GenericNativeIndexPopulatorTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule());

    @Test
    public void dropShouldDeleteEntireIndexFolder() {
        File root = this.storage.directory().directory("root");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((File)root).forProvider(GenericNativeIndexProvider.DESCRIPTOR);
        long indexId = 8L;
        File indexDirectory = directoryStructure.directoryForIndex(indexId);
        StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1})).withId(indexId);
        IndexSpecificSpaceFillingCurveSettingsCache spatialSettings = (IndexSpecificSpaceFillingCurveSettingsCache)Mockito.mock(IndexSpecificSpaceFillingCurveSettingsCache.class);
        PageCache pageCache = this.storage.pageCache();
        FileSystemAbstraction fs = this.storage.fileSystem();
        File indexFile = new File(indexDirectory, "my-index");
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        RecoveryCleanupWorkCollector immediate = RecoveryCleanupWorkCollector.immediate();
        FileSystemIndexDropAction dropAction = new FileSystemIndexDropAction(fs, directoryStructure);
        GenericNativeIndexPopulator populator = new GenericNativeIndexPopulator(pageCache, fs, indexFile, (IndexLayout)layout, IndexProvider.Monitor.EMPTY, descriptor, spatialSettings, directoryStructure, (SpaceFillingCurveConfiguration)Mockito.mock(SpaceFillingCurveConfiguration.class), (IndexDropAction)dropAction, false, SchemaTestUtil.simpleNameLookup);
        populator.create();
        Assert.assertTrue((fs.listFiles(indexDirectory).length > 0 ? 1 : 0) != 0);
        populator.drop();
        Assert.assertFalse((boolean)fs.fileExists(indexDirectory));
    }
}

