/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTestCases;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

@RunWith(value=Parameterized.class)
public class NativeNonUniqueIndexPopulatorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulatorTests.NonUnique<KEY, VALUE> {
    @Parameterized.Parameter
    public NativeIndexPopulatorTestCases.TestCase<KEY, VALUE> testCase;
    private static final StoreIndexDescriptor nonUniqueDescriptor = TestIndexDescriptorFactory.forLabel(42, 666).withId(0L);

    @Parameterized.Parameters(name="{index} {0}")
    public static Collection<Object[]> data() {
        return NativeIndexPopulatorTestCases.allCases();
    }

    @Override
    NativeIndexPopulator<KEY, VALUE> createPopulator() throws IOException {
        return this.testCase.populatorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.getIndexFile(), this.layout, this.monitor, this.indexDescriptor, this.tokenNameLookup);
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(nonUniqueDescriptor, this.testCase.typesOfGroup, 0.1);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.testCase.indexLayoutFactory.create();
    }
}

