/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeIndexKey;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class ZonedDateTimeIndexKeyTest {
    @Test
    public void compareToSameAsValue() {
        Value[] values = new Value[]{DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("-18:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneOffset)ZoneOffset.of("-17:59:59")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00")), DateTimeValue.datetime((long)10000L, (long)101L, (ZoneId)ZoneId.of("-18:00"))};
        ZonedDateTimeIndexKey keyI = new ZonedDateTimeIndexKey();
        ZonedDateTimeIndexKey keyJ = new ZonedDateTimeIndexKey();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                Value vi = values[i];
                Value vj = values[j];
                vi.writeTo((ValueWriter)keyI);
                vj.writeTo((ValueWriter)keyJ);
                int expected = Integer.signum(Values.COMPARATOR.compare(vi, vj));
                Assert.assertEquals((String)String.format("comparing %s and %s", vi, vj), (long)expected, (long)Integer.signum(i - j));
                Assert.assertEquals((String)String.format("comparing %s and %s", vi, vj), (long)expected, (long)Integer.signum(keyI.compareValueTo(keyJ)));
            }
        }
    }
}

