/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.newapi.SortedMergeJoin;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class SortedMergeJoinTest {
    @Parameterized.Parameter
    public IndexOrder indexOrder;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({IndexOrder.ASCENDING}, {IndexOrder.DESCENDING});
    }

    @Test
    public void shouldWorkWithEmptyLists() {
        this.assertThatItWorksOneWay(Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void shouldWorkWithAList() {
        this.assertThatItWorks(Arrays.asList(this.node(1L, "a"), this.node(3L, "aa"), this.node(5L, "c"), this.node(7L, "g")), Collections.emptyList());
    }

    @Test
    public void shouldWorkWith2Lists() {
        this.assertThatItWorks(Arrays.asList(this.node(1L, "a"), this.node(3L, "aa"), this.node(5L, "c"), this.node(7L, "g")), Arrays.asList(this.node(2L, "b"), this.node(4L, "ba"), this.node(6L, "ca"), this.node(8L, "d")));
    }

    @Test
    public void shouldWorkWithSameElements() {
        this.assertThatItWorks(Arrays.asList(this.node(1L, "a"), this.node(3L, "b"), this.node(5L, "c")), Arrays.asList(this.node(2L, "aa"), this.node(3L, "b"), this.node(6L, "ca")));
    }

    @Test
    public void shouldWorkWithCompositeValues() {
        this.assertThatItWorks(Arrays.asList(this.node(1L, "a", "a"), this.node(3L, "b", "a"), this.node(5L, "b", "b"), this.node(7L, "c", "d")), Arrays.asList(this.node(2L, "a", "b"), this.node(5L, "b", "b"), this.node(6L, "c", "e")));
    }

    private void assertThatItWorks(List<NodeWithPropertyValues> listA, List<NodeWithPropertyValues> listB) {
        this.assertThatItWorksOneWay(listA, listB);
        this.assertThatItWorksOneWay(listB, listA);
    }

    private void assertThatItWorksOneWay(List<NodeWithPropertyValues> listA, List<NodeWithPropertyValues> listB) {
        SortedMergeJoin sortedMergeJoin = new SortedMergeJoin();
        sortedMergeJoin.initialize(this.indexOrder);
        Comparator comparator = this.indexOrder == IndexOrder.ASCENDING ? (a, b) -> ValueTuple.COMPARATOR.compare(ValueTuple.of((Value[])a.getValues()), ValueTuple.of((Value[])b.getValues())) : (a, b) -> ValueTuple.COMPARATOR.compare(ValueTuple.of((Value[])b.getValues()), ValueTuple.of((Value[])a.getValues()));
        listA.sort(comparator);
        listB.sort(comparator);
        List<NodeWithPropertyValues> result = this.process(sortedMergeJoin, listA.iterator(), listB.iterator());
        ArrayList<NodeWithPropertyValues> expected = new ArrayList<NodeWithPropertyValues>();
        expected.addAll(listA);
        expected.addAll(listB);
        expected.sort(comparator);
        MatcherAssert.assertThat(result, (Matcher)Matchers.equalTo(expected));
    }

    private List<NodeWithPropertyValues> process(SortedMergeJoin sortedMergeJoin, Iterator<NodeWithPropertyValues> iteratorA, Iterator<NodeWithPropertyValues> iteratorB) {
        Collector collector = new Collector();
        while (!collector.done) {
            if (iteratorA.hasNext() && sortedMergeJoin.needsA()) {
                NodeWithPropertyValues a = iteratorA.next();
                sortedMergeJoin.setA(a.getNodeId(), a.getValues());
            }
            if (iteratorB.hasNext() && sortedMergeJoin.needsB()) {
                NodeWithPropertyValues b = iteratorB.next();
                sortedMergeJoin.setB(b.getNodeId(), b.getValues());
            }
            sortedMergeJoin.next((SortedMergeJoin.Sink)collector);
        }
        return collector.result;
    }

    private NodeWithPropertyValues node(long id, Object ... values) {
        return new NodeWithPropertyValues(id, (Value[])Stream.of(values).map(Values::of).toArray(Value[]::new));
    }

    class Collector
    implements SortedMergeJoin.Sink {
        final List<NodeWithPropertyValues> result = new ArrayList<NodeWithPropertyValues>();
        boolean done;

        Collector() {
        }

        public void acceptSortedMergeJoin(long nodeId, Value[] values) {
            if (nodeId == -1L) {
                this.done = true;
            } else {
                this.result.add(new NodeWithPropertyValues(nodeId, values));
            }
        }
    }
}

