/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.FieldInjections;
import org.neo4j.procedure.Context;

public class FieldInjectionsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldNotAllowClassesWithNonInjectedFields() throws Throwable {
        FieldInjections injections = new FieldInjections(new ComponentRegistry());
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Field `someState` on `ProcedureWithNonInjectedMemberFields` is not annotated as a @Context and is not static. If you want to store state along with your procedure, please use a static field.");
        injections.setters(ProcedureWithNonInjectedMemberFields.class);
    }

    @Test
    public void shouldNotAllowNonPublicFieldsForInjection() throws Throwable {
        FieldInjections injections = new FieldInjections(new ComponentRegistry());
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Field `someState` on `ProcedureWithPrivateMemberField` must be non-final and public.");
        injections.setters(ProcedureWithPrivateMemberField.class);
    }

    @Test
    public void staticFieldsAreAllowed() throws Throwable {
        FieldInjections injections = new FieldInjections(new ComponentRegistry());
        List setters = injections.setters(ProcedureWithStaticFields.class);
        Assert.assertEquals((long)0L, (long)setters.size());
    }

    @Test
    public void inheritanceIsAllowed() throws Throwable {
        ComponentRegistry components = new ComponentRegistry();
        components.register(Integer.TYPE, ctx -> 1337);
        FieldInjections injections = new FieldInjections(components);
        List setters = injections.setters(ChildProcedure.class);
        ChildProcedure childProcedure = new ChildProcedure();
        for (FieldInjections.FieldSetter setter : setters) {
            setter.apply(null, (Object)childProcedure);
        }
        Assert.assertEquals((long)1337L, (long)childProcedure.childField);
        Assert.assertEquals((long)1337L, (long)childProcedure.parentField);
    }

    @Test
    public void syntheticsAllowed() throws Throwable {
        ComponentRegistry components = new ComponentRegistry();
        components.register(Integer.TYPE, ctx -> 1337);
        FieldInjections injections = new FieldInjections(components);
        List setters = injections.setters(Outer.ClassWithSyntheticField.class);
        Outer.ClassWithSyntheticField syntheticField = new Outer().classWithSyntheticField();
        for (FieldInjections.FieldSetter setter : setters) {
            setter.apply(null, (Object)syntheticField);
        }
        Assert.assertEquals((long)1337L, (long)syntheticField.innerField);
    }

    public static class Outer {
        ClassWithSyntheticField classWithSyntheticField() {
            return new ClassWithSyntheticField();
        }

        public class ClassWithSyntheticField {
            @Context
            public int innerField;
        }
    }

    public static class ChildProcedure
    extends ParentProcedure {
        @Context
        public int childField;
    }

    public static class ParentProcedure {
        @Context
        public int parentField;
    }

    public static class ProcedureWithStaticFields {
        private static boolean someState;
    }

    public static class ProcedureWithPrivateMemberField {
        @Context
        private boolean someState;
    }

    public static class ProcedureWithNonInjectedMemberFields {
        public boolean someState;
    }
}

