/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class SchemaStoreTest {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.testDirectory);
    private Config config;
    private SchemaStore store;
    private NeoStores neoStores;
    private StoreFactory storeFactory;

    @Before
    public void before() {
        this.config = Config.defaults();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fs.get());
        this.storeFactory = new StoreFactory(this.testDirectory.databaseLayout(), this.config, (IdGeneratorFactory)idGeneratorFactory, pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        this.store = this.neoStores.getSchemaStore();
    }

    @After
    public void after() {
        this.neoStores.close();
    }

    @Test
    public void storeAndLoadSchemaRule() throws Exception {
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{4}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoadCompositeSchemaRule() throws Exception {
        int[] propertyIds = new int[]{4, 5, 6, 7};
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)2, (int[])propertyIds), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoadMultiTokenSchemaRule() throws Exception {
        int[] propertyIds = new int[]{4, 5, 6, 7};
        int[] entityTokens = new int[]{2, 3, 4};
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])entityTokens, (EntityType)EntityType.RELATIONSHIP, (int[])propertyIds), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoadAnyTokenMultiTokenSchemaRule() throws Exception {
        int[] propertyIds = new int[]{4, 5, 6, 7};
        int[] entityTokens = new int[]{};
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])entityTokens, (EntityType)EntityType.NODE, (int[])propertyIds), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoad_Big_CompositeSchemaRule() throws Exception {
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)2, (int[])IntStream.range(1, 200).toArray()), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoad_Big_CompositeMultiTokenSchemaRule() throws Exception {
        StoreIndexDescriptor indexRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])IntStream.range(1, 200).toArray(), (EntityType)EntityType.RELATIONSHIP, (int[])IntStream.range(1, 200).toArray()), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(this.store.nextId());
        StoreIndexDescriptor readIndexRule = (StoreIndexDescriptor)SchemaRuleSerialization.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(SchemaRuleSerialization.serialize((StoreIndexDescriptor)indexRule)));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.schema(), (Object)readIndexRule.schema());
        Assert.assertEquals((Object)indexRule, (Object)readIndexRule);
        Assert.assertEquals((Object)indexRule.providerDescriptor(), (Object)readIndexRule.providerDescriptor());
    }

    @Test
    public void storeAndLoadAllRules() {
        long indexId = this.store.nextId();
        long constraintId = this.store.nextId();
        List<SchemaRule> rules = Arrays.asList(this.uniqueIndexRule(indexId, constraintId, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 2, 5, 3), this.constraintUniqueRule(constraintId, indexId, 2, 5, 3), this.indexRule(this.store.nextId(), TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 0, 5), this.indexRule(this.store.nextId(), TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, 1, 6, 10, 99), this.constraintExistsRule(this.store.nextId(), 5, 1));
        for (SchemaRule rule : rules) {
            this.storeRule(rule);
        }
        Collection readRules = Iterators.asCollection((Iterator)this.store.loadAllSchemaRules());
        Assert.assertEquals(rules, (Object)readRules);
    }

    private long storeRule(SchemaRule rule) {
        List records = this.store.allocateFrom(rule);
        for (DynamicRecord record : records) {
            this.store.updateRecord((AbstractBaseRecord)record);
        }
        return ((DynamicRecord)Iterables.first((Iterable)records)).getId();
    }

    private StoreIndexDescriptor indexRule(long ruleId, IndexProviderDescriptor descriptor, int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), (IndexProviderDescriptor)descriptor).withId(ruleId);
    }

    private StoreIndexDescriptor uniqueIndexRule(long ruleId, long owningConstraint, IndexProviderDescriptor descriptor, int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), (IndexProviderDescriptor)descriptor).withIds(ruleId, owningConstraint);
    }

    private ConstraintRule constraintUniqueRule(long ruleId, long ownedIndexId, int labelId, int ... propertyIds) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyIds), (long)ownedIndexId);
    }

    private ConstraintRule constraintExistsRule(long ruleId, int labelId, int ... propertyIds) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])propertyIds));
    }
}

