/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.time.Clock;
import java.util.stream.LongStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class LogPruningTest {
    private final Config config = Config.defaults();
    private FileSystemAbstraction fs;
    private LogFiles logFiles;
    private LogProvider logProvider;
    private Clock clock;
    private LogPruneStrategyFactory factory;

    @Before
    public void setUp() {
        this.fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        ((LogFiles)Mockito.doAnswer(inv -> new File(String.valueOf(inv.getArguments()[0]))).when((Object)this.logFiles)).getLogFileForVersion(ArgumentMatchers.anyLong());
        this.logProvider = NullLogProvider.getInstance();
        this.clock = (Clock)Mockito.mock(Clock.class);
        this.factory = (LogPruneStrategyFactory)Mockito.mock(LogPruneStrategyFactory.class);
    }

    @Test
    public void mustDeleteLogFilesThatCanBePruned() {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(upTo -> LongStream.range(3L, upTo));
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, this.logProvider, this.factory, this.clock, this.config);
        pruning.pruneLogs(5L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.fs});
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(new File("3"));
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(new File("4"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fs});
    }

    @Test
    public void mustHaveLogFilesToPruneIfStrategyFindsFiles() {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(upTo -> LongStream.range(3L, upTo));
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)4L);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, this.logProvider, this.factory, this.clock, this.config);
        Assert.assertTrue((boolean)pruning.mightHaveLogsToPrune(this.logFiles.getHighestLogVersion()));
    }

    @Test
    public void mustNotHaveLogsFilesToPruneIfStrategyFindsNoFiles() {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(x -> LongStream.empty());
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, this.logProvider, this.factory, this.clock, this.config);
        Assert.assertFalse((boolean)pruning.mightHaveLogsToPrune(this.logFiles.getHighestLogVersion()));
    }
}

