/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;

public class RecordChangeSetTest {
    @Test
    public void shouldStartWithSetsInitializedAndEmpty() {
        RecordChangeSet changeSet = new RecordChangeSet((Loaders)Mockito.mock(Loaders.class));
        Assert.assertEquals((long)0L, (long)changeSet.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getPropertyRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getSchemaRuleChanges().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelGroupRecords().changeSize());
    }

    @Test
    public void shouldClearStateOnClose() {
        NeoStores mockStore = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore store = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)mockStore.getNodeStore()).thenReturn((Object)store);
        RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        Mockito.when((Object)mockStore.getRelationshipStore()).thenReturn((Object)relationshipStore);
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        Mockito.when((Object)mockStore.getPropertyStore()).thenReturn((Object)propertyStore);
        SchemaStore schemaStore = (SchemaStore)Mockito.mock(SchemaStore.class);
        Mockito.when((Object)mockStore.getSchemaStore()).thenReturn((Object)schemaStore);
        RelationshipGroupStore groupStore = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
        Mockito.when((Object)mockStore.getRelationshipGroupStore()).thenReturn((Object)groupStore);
        RecordChangeSet changeSet = new RecordChangeSet(new Loaders(mockStore));
        changeSet.getNodeRecords().create(1L, null).forChangingLinkage();
        changeSet.getPropertyRecords().create(1L, null).forChangingLinkage();
        changeSet.getRelRecords().create(1L, null).forChangingLinkage();
        changeSet.getSchemaRuleChanges().create(1L, null).forChangingLinkage();
        changeSet.getRelGroupRecords().create(1L, (Object)1).forChangingLinkage();
        changeSet.close();
        Assert.assertEquals((long)0L, (long)changeSet.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getPropertyRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getSchemaRuleChanges().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelGroupRecords().changeSize());
    }
}

