/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class LabelIndexWriterStep
extends ProcessorStep<NodeRecord[]> {
    private final LabelScanWriter writer;
    private final NodeStore nodeStore;

    public LabelIndexWriterStep(StageControl control, Configuration config, LabelScanStore store, NodeStore nodeStore) {
        super(control, "LABEL INDEX", config, 1, new StatsProvider[0]);
        this.writer = store.newWriter();
        this.nodeStore = nodeStore;
    }

    @Override
    protected void process(NodeRecord[] batch, BatchSender sender) throws Throwable {
        for (NodeRecord node : batch) {
            if (!node.inUse()) continue;
            this.writer.write(NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, NodeLabelsField.get(node, this.nodeStore)));
        }
        sender.send(batch);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.writer.close();
    }
}

