/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.atomic.AtomicReference;
import org.mockito.Mockito;
import org.neo4j.collection.pool.Pool;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.test.MockedNeoStores;
import org.neo4j.time.Clocks;

public class KernelTransactionFactory {
    private KernelTransactionFactory() {
    }

    static Instances kernelTransactionWithInternals(LoginContext loginContext) {
        TransactionHeaderInformation headerInformation = new TransactionHeaderInformation(-1, -1, new byte[0]);
        TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
        Mockito.when((Object)headerInformationFactory.create()).thenReturn((Object)headerInformation);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        Mockito.when((Object)storageEngine.newReader()).thenReturn((Object)storageReader);
        KernelTransactionImplementation transaction = new KernelTransactionImplementation(Config.defaults(), (StatementOperationParts)Mockito.mock(StatementOperationParts.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), new TransactionHooks(), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), new Procedures(), headerInformationFactory, (TransactionCommitProcess)Mockito.mock(TransactionRepresentationCommitProcess.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), (AuxiliaryTransactionStateManager)Mockito.mock(AuxiliaryTransactionStateManager.class), (Pool)Mockito.mock(Pool.class), Clocks.systemClock(), new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE), TransactionTracer.NULL, LockTracer.NONE, PageCursorTracerSupplier.NULL, storageEngine, (AccessCapability)new CanWrite(), AutoIndexing.UNSUPPORTED, (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class), EmptyVersionContextSupplier.EMPTY, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), (IndexingProvidersService)Mockito.mock(IndexingService.class), MockedNeoStores.mockedTokenHolders(), new Dependencies());
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(0L, 0L, (StatementLocks)statementLocks, Transaction.Type.implicit, loginContext.authorize(s -> -1, "graph.db"), 0L, 1L);
        return new Instances(transaction);
    }

    static KernelTransaction kernelTransaction(LoginContext loginContext) {
        return KernelTransactionFactory.kernelTransactionWithInternals((LoginContext)loginContext).transaction;
    }

    public static class Instances {
        public KernelTransactionImplementation transaction;

        public Instances(KernelTransactionImplementation transaction) {
            this.transaction = transaction;
        }
    }
}

