/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.test.Race;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ArrayEncoderTest {
    @Rule
    public final ThreadingRule threads = new ThreadingRule();
    private static final Character[] base64chars = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('+'), Character.valueOf('/')};
    private static final char ARRAY_ENTRY_SEPARATOR = '|';
    private static final char PADDING = '=';

    @Test
    public void encodingShouldContainOnlyBase64EncodingChars() {
        String[] array = new String[]{"This string is long enough for BASE64 to emit a line break, making the encoding platform dependant.", "Something else to trigger padding."};
        String encoded = ArrayEncoder.encode((Value)Values.of((Object)array));
        int separators = 0;
        boolean padding = false;
        for (int i = 0; i < encoded.length(); ++i) {
            char character = encoded.charAt(i);
            if (character == '|') {
                padding = false;
                ++separators;
                continue;
            }
            if (padding) {
                Assert.assertEquals((long)61L, (long)character);
                continue;
            }
            if (character == '=') {
                padding = true;
                continue;
            }
            Assert.assertTrue((String)("Char " + character + " at position " + i + " is not a valid Base64 encoded char"), (boolean)ArrayUtil.contains((Object[])base64chars, (Object)Character.valueOf(character)));
        }
        Assert.assertEquals((long)array.length, (long)separators);
    }

    @Test
    public void shouldEncodeArrays() {
        this.assertEncoding("D1.0|2.0|3.0|", new int[]{1, 2, 3});
        this.assertEncoding("Ztrue|false|", new boolean[]{true, false});
        this.assertEncoding("LYWxp|YXJl|eW91|b2s=|", new String[]{"ali", "are", "you", "ok"});
        this.assertEncoding("", new String[0]);
        this.assertEncoding("P1:4326:1.234;2.567|1:4326:2.345;5.678|2:9157:3.0;4.0;5.0|", new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.234, 2.567}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{2.345, 5.678}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{3.0, 4.0, 5.0})});
        this.assertEncoding("T1991-03-05|1992-04-06|", new LocalDate[]{(LocalDate)DateValue.date((int)1991, (int)3, (int)5).asObjectCopy(), (LocalDate)DateValue.date((int)1992, (int)4, (int)6).asObjectCopy()});
        this.assertEncoding("T12:45:13.000008676|05:04:50.000000076|", new LocalTime[]{(LocalTime)LocalTimeValue.localTime((int)12, (int)45, (int)13, (int)8676).asObjectCopy(), (LocalTime)LocalTimeValue.localTime((int)5, (int)4, (int)50, (int)76).asObjectCopy()});
        this.assertEncoding("T1991-03-05T12:45:13.000008676|1992-04-06T05:04:50.000000076|", new LocalDateTime[]{(LocalDateTime)LocalDateTimeValue.localDateTime((int)1991, (int)3, (int)5, (int)12, (int)45, (int)13, (int)8676).asObjectCopy(), (LocalDateTime)LocalDateTimeValue.localDateTime((int)1992, (int)4, (int)6, (int)5, (int)4, (int)50, (int)76).asObjectCopy()});
        this.assertEncoding("T02:45:13.000008676Z|01:05:00.0000003+01:00|05:04:50.000000076+05:00|", new OffsetTime[]{(OffsetTime)TimeValue.time((int)2, (int)45, (int)13, (int)8676, (ZoneOffset)ZoneOffset.UTC).asObjectCopy(), (OffsetTime)TimeValue.time((OffsetTime)OffsetTime.ofInstant(Instant.ofEpochSecond(300L, 300L), ZoneId.of("Europe/Stockholm"))).asObjectCopy(), (OffsetTime)TimeValue.time((int)5, (int)4, (int)50, (int)76, (String)"+05:00").asObjectCopy()});
        this.assertEncoding("T1991-03-05T02:45:13.000008676Z|1991-03-05T02:45:13.000008676+01:00[Europe/Stockholm]|1992-04-06T05:04:50.000000076+05:00|", new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.datetime((int)1991, (int)3, (int)5, (int)2, (int)45, (int)13, (int)8676, (ZoneId)ZoneOffset.UTC).asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1991, (int)3, (int)5, (int)2, (int)45, (int)13, (int)8676, (ZoneId)ZoneId.of("Europe/Stockholm")).asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)4, (int)6, (int)5, (int)4, (int)50, (int)76, (String)"+05:00").asObjectCopy()});
        this.assertEncoding("AP165Y11M3DT5.000000012S|P166Y4DT6.000000005S|", new TemporalAmount[]{DurationValue.duration((long)1991L, (long)3L, (long)5L, (long)12L).asObjectCopy(), DurationValue.duration((long)1992L, (long)4L, (long)6L, (long)5L).asObjectCopy()});
    }

    @Test
    public void shouldEncodeProperlyWithMultipleThreadsRacing() throws Throwable {
        String[] INPUT = new String[]{"These strings need to be longer than 57 bytes, because that is the line wrapping length of BASE64.", "This next line is also long. The number of strings in this array is the number of threads to use.", "Each thread will get a different string as input to encode, and ensure the result is always the same.", "Should the result of an encoding differ even once, the thread will yield a negative overall result.", "If any of the threads yields a negative result, the test will fail, since that should not happen.", "All threads are allowed to run together for a predetermined amount of time, to try to get contention.", "This predetermined time is the minimum runtime of the test, since the timer starts after all threads.", "The idea to use the input data as documentation for the test was just a cute thing I came up with.", "Since my imagination for coming up with test data is usually poor, I figured I'd do something useful.", "Hopefully this isn't just nonsensical drivel, and maybe, just maybe someone might actually read it."};
        this.raceEncode(INPUT, ArrayEncoder::encode);
    }

    private void raceEncode(String[] INPUT, Function<Value, String> encodeFunction) throws Throwable {
        Race race = new Race();
        for (String input : INPUT) {
            Value inputValue = Values.of((Object)new String[]{input});
            race.addContestant(() -> {
                String first = (String)encodeFunction.apply(inputValue);
                for (int i = 0; i < 1000; ++i) {
                    String encoded = (String)encodeFunction.apply(inputValue);
                    Assert.assertEquals((String)("Each attempt at encoding should yield the same result. Turns out that first one was '" + first + "', yet another one was '" + encoded + "'"), (Object)first, (Object)encoded);
                }
            });
        }
        race.go();
    }

    private void assertEncoding(String expected, Object toEncode) {
        Assert.assertEquals((Object)expected, (Object)ArrayEncoder.encode((Value)Values.of((Object)toEncode)));
    }
}

