/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class EntityUpdatesTest {
    private static final long nodeId = 0L;
    private static final int labelId1 = 0;
    private static final int labelId2 = 1;
    private static final int unusedLabelId = 2;
    private static final int propertyKeyId1 = 0;
    private static final int propertyKeyId2 = 1;
    private static final int propertyKeyId3 = 2;
    private static final long[] label = new long[]{0L};
    private static final long[] allLabels = new long[]{0L, 1L};
    private static final long[] empty = new long[0];
    private static final LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static final LabelSchemaDescriptor index2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    private static final LabelSchemaDescriptor index3 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{2});
    private static final LabelSchemaDescriptor index123 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1, 2});
    private static final List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index123);
    private static final MultiTokenSchemaDescriptor nonSchemaIndex = SchemaDescriptorFactory.multiToken((int[])new int[]{0, 1}, (EntityType)EntityType.NODE, (int[])new int[]{0, 1, 2});
    private static final StorageProperty property1 = new PropertyKeyValue(0, Values.of((Object)"Neo"));
    private static final StorageProperty property2 = new PropertyKeyValue(1, Values.of((Object)100L));
    private static final StorageProperty property3 = new PropertyKeyValue(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    private static final Value[] values123 = new Value[]{property1.value(), property2.value(), property3.value()};

    @Test
    public void shouldNotGenerateUpdatesForEmptyNodeUpdates() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdateForMultipleExistingPropertiesAndLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAdditionWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdateForPartialCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index123), this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForWhenCompletingCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index123), this.propertyLoader(property2), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemovalWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdatesForSinglePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForMultiplePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(label).removed(property1.propertyKeyId(), property1.value()).removed(property2.propertyKeyId(), property2.value()).removed(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(empty).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForLabelsAndNoPropertyChanges() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForPartialNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{property1.value(), null, null})}));
    }

    @Test
    public void shouldGenerateUpdateForFullNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    public void shouldGenerateUpdateForSingleChangeNonSchemaIndex() {
        Value newValue2 = Values.of((Object)10L);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).changed(property2.propertyKeyId(), property2.value(), newValue2).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), newValue2, property3.value()})}));
    }

    @Test
    public void shouldGenerateUpdateForAllChangedNonSchemaIndex() {
        Value newValue1 = Values.of((Object)"Nio");
        Value newValue2 = Values.of((Object)10L);
        PointValue newValue3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{32.3, 15.6});
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).changed(property1.propertyKeyId(), property1.value(), newValue1).changed(property2.propertyKeyId(), property2.value(), newValue2).changed(property3.propertyKeyId(), property3.value(), (Value)newValue3).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{newValue1, newValue2, newValue3})}));
    }

    @Test
    public void shouldGenerateUpdateWhenRemovingLastPropForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property2), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{null, property2.value(), null})}));
    }

    @Test
    public void shouldGenerateUpdateWhenRemovingOnePropertyForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), null, property3.value()})}));
    }

    @Test
    public void shouldGenerateUpdateWhenAddingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    public void shouldGenerateUpdateWhenAddingMultipleTokensForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(empty).withTokensAfter(allLabels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdateWhenAddingAnotherTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(allLabels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdateWhenAddingAnotherUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(new long[]{0L, 2L}).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateWhenSwitchingToUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(new long[]{2L}).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdateWhenRemovingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(allLabels).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateWhenRemovingLastTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), this.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    private PropertyLoader propertyLoader(StorageProperty ... properties) {
        HashMap<Integer, Value> propertyMap = new HashMap<Integer, Value>();
        for (StorageProperty p : properties) {
            propertyMap.put(p.propertyKeyId(), p.value());
        }
        return (nodeId1, type, propertyIds, sink) -> {
            MutableIntIterator iterator = propertyIds.intIterator();
            while (iterator.hasNext()) {
                int propertyId = iterator.next();
                if (!propertyMap.containsKey(propertyId)) continue;
                sink.onProperty(propertyId, (Value)propertyMap.get(propertyId));
                iterator.remove();
            }
        };
    }

    private PropertyLoader assertNoLoading() {
        return (nodeId1, type, propertyIds, sink) -> Assert.fail((String)"Should never attempt to load properties!");
    }
}

