/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConstraintIndexCreatorTest {
    private static final int PROPERTY_KEY_ID = 456;
    private static final int LABEL_ID = 123;
    private static final long INDEX_ID = 0L;
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
    private final IndexDescriptor index = TestIndexDescriptorFactory.uniqueForLabel(123, 456);
    private final IndexReference indexReference = TestIndexDescriptorFactory.uniqueForLabel(123, 456);
    private final SchemaRead schemaRead = this.schemaRead();
    private final SchemaWrite schemaWrite = (SchemaWrite)Mockito.mock(SchemaWrite.class);
    private final TokenRead tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexingService.getIndexProxy(0L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index.withId(0L).withoutCapabilities());
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        long indexId = creator.createUniquenessConstraintIndex(this.createTransaction(), (SchemaDescriptor)this.descriptor, ConstraintIndexCreatorTest.getDefaultProvider());
        Assert.assertEquals((long)0L, (long)indexId);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId(this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index((SchemaDescriptor)this.descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(0L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index.withId(0L).withoutCapabilities());
        IndexEntryConflictException cause = new IndexEntryConflictException(2L, 1L, new Value[]{Values.of((Object)"a")});
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new IndexPopulationFailedKernelException("some index", (Throwable)cause)}).when((Object)indexProxy)).awaitStoreScanCompleted();
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class))).thenReturn((Object)IndexReference.NO_INDEX).thenReturn((Object)this.indexReference);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        try {
            creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, ConstraintIndexCreatorTest.getDefaultProvider());
            Assert.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( label[123]:label[123] ) ASSERT label[123].property[456] IS UNIQUE: Both node 2 and node 1 share the property value ( String(\"a\") )", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)kernel.transactions.size());
        KernelTransactionImplementation tx1 = (KernelTransactionImplementation)kernel.transactions.get(0);
        SchemaDescriptor newIndex = this.index.schema();
        ((KernelTransactionImplementation)Mockito.verify((Object)tx1)).indexUniqueCreate((SchemaDescriptor)ArgumentMatchers.eq((Object)newIndex), (String)ArgumentMatchers.eq((Object)ConstraintIndexCreatorTest.getDefaultProvider()));
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId(this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead, (VerificationMode)Mockito.times((int)2))).index((SchemaDescriptor)this.descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        TransactionState tx2 = ((KernelTransactionImplementation)kernel.transactions.get(1)).txState();
        ((TransactionState)Mockito.verify((Object)tx2)).indexDoDrop(this.index);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        creator.dropUniquenessConstraintIndex(this.index);
        Assert.assertEquals((long)1L, (long)kernel.transactions.size());
        ((TransactionState)Mockito.verify((Object)((KernelTransactionImplementation)kernel.transactions.get(0)).txState())).indexDoDrop(this.index);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    @Test
    public void shouldReleaseLabelLockWhileAwaitingIndexPopulation() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.indexGetCommittedId(this.indexReference)).thenReturn((Object)0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(ArgumentMatchers.anyLong())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.schemaRead.index(123, new int[]{456})).thenReturn((Object)IndexReference.NO_INDEX);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, ConstraintIndexCreatorTest.getDefaultProvider());
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).acquireExclusive(transaction.lockTracer(), (ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
    }

    @Test
    public void shouldReuseExistingOrphanedConstraintIndex() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long orphanedConstraintIndexId = 111L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId(this.indexReference)).thenReturn((Object)orphanedConstraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(orphanedConstraintIndexId)).thenReturn((Object)indexProxy);
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.descriptor)).thenReturn((Object)this.indexReference);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId(this.indexReference)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        long indexId = creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, ConstraintIndexCreatorTest.getDefaultProvider());
        Assert.assertEquals((long)orphanedConstraintIndexId, (long)indexId);
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.transactions.size());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId(this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index((SchemaDescriptor)this.descriptor);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetOwningUniquenessConstraintId(this.indexReference);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldFailOnExistingOwnedConstraintIndex() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long constraintIndexId = 111L;
        long constraintIndexOwnerId = 222L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId(this.indexReference)).thenReturn((Object)constraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(constraintIndexId)).thenReturn((Object)indexProxy);
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.descriptor)).thenReturn((Object)this.indexReference);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId(this.indexReference)).thenReturn((Object)constraintIndexOwnerId);
        Mockito.when((Object)this.tokenRead.nodeLabelName(123)).thenReturn((Object)"MyLabel");
        Mockito.when((Object)this.tokenRead.propertyKeyName(456)).thenReturn((Object)"MyKey");
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        try {
            KernelTransactionImplementation transaction = this.createTransaction();
            creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, ConstraintIndexCreatorTest.getDefaultProvider());
            Assert.fail((String)"Should've failed");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.transactions.size());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index((SchemaDescriptor)this.descriptor);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetOwningUniquenessConstraintId(this.indexReference);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    public void shouldCreateConstraintIndexForSpecifiedProvider() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)this.schemaRead.indexGetCommittedId(this.indexReference)).thenReturn((Object)0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(0L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, nodePropertyAccessor, (LogProvider)this.logProvider);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("Groovy", "1.2");
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, providerDescriptor.name());
        Assert.assertEquals((long)1L, (long)kernel.transactions.size());
        KernelTransactionImplementation transactionInstance = (KernelTransactionImplementation)kernel.transactions.get(0);
        ((KernelTransactionImplementation)Mockito.verify((Object)transactionInstance)).indexUniqueCreate((SchemaDescriptor)ArgumentMatchers.eq((Object)this.descriptor), (String)ArgumentMatchers.eq((Object)providerDescriptor.name()));
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index((SchemaDescriptor)this.descriptor);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId((IndexReference)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    public void logMessagesAboutConstraintCreation() throws SchemaKernelException, UniquePropertyValueValidationException, TransactionFailureException, IndexNotFoundKernelException {
        StubKernel kernel = new StubKernel();
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexingService.getIndexProxy(0L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index.withId(0L).withoutCapabilities());
        NodePropertyAccessor propertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, "indexProviderByName-1.0");
        this.logProvider.assertContainsLogCallContaining("Starting constraint creation: %s.");
        this.logProvider.assertContainsLogCallContaining("Constraint %s populated, starting verification.");
        this.logProvider.assertContainsLogCallContaining("Constraint %s verified.");
    }

    private SchemaRead schemaRead() {
        SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        Mockito.when((Object)schemaRead.index((SchemaDescriptor)this.descriptor)).thenReturn((Object)IndexReference.NO_INDEX);
        try {
            Mockito.when((Object)schemaRead.indexGetCommittedId(this.indexReference)).thenReturn((Object)0L);
        }
        catch (SchemaKernelException e) {
            throw new AssertionError((Object)e);
        }
        return schemaRead;
    }

    private KernelTransactionImplementation createTransaction() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        try {
            TransactionHeaderInformation headerInformation = new TransactionHeaderInformation(-1, -1, new byte[0]);
            TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
            Mockito.when((Object)headerInformationFactory.create()).thenReturn((Object)headerInformation);
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
            Mockito.when((Object)storageEngine.newReader()).thenReturn((Object)storageReader);
            SimpleStatementLocks locks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
            Mockito.when((Object)transaction.statementLocks()).thenReturn((Object)locks);
            Mockito.when((Object)transaction.tokenRead()).thenReturn((Object)this.tokenRead);
            Mockito.when((Object)transaction.schemaRead()).thenReturn((Object)this.schemaRead);
            Mockito.when((Object)transaction.schemaWrite()).thenReturn((Object)this.schemaWrite);
            TransactionState transactionState = (TransactionState)Mockito.mock(TransactionState.class);
            Mockito.when((Object)transaction.txState()).thenReturn((Object)transactionState);
            Mockito.when((Object)transaction.indexUniqueCreate((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class), (String)ArgumentMatchers.any(String.class))).thenAnswer(i -> IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)((SchemaDescriptor)i.getArgument(0))));
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assert.fail((String)"Expected write transaction");
        }
        catch (SchemaKernelException e) {
            throw new RuntimeException(e);
        }
        return transaction;
    }

    private static String getDefaultProvider() {
        return (String)Config.defaults().get(GraphDatabaseSettings.default_schema_provider);
    }

    private class StubKernel
    implements Kernel {
        private final List<KernelTransactionImplementation> transactions = new ArrayList<KernelTransactionImplementation>();

        private StubKernel() {
        }

        private KernelTransaction remember(KernelTransactionImplementation kernelTransaction) {
            this.transactions.add(kernelTransaction);
            return kernelTransaction;
        }

        public Transaction beginTransaction(Transaction.Type type, LoginContext loginContext) {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }
    }
}

