/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

public class IndexMapTest {
    private static final long[] noEntityToken = new long[0];
    private IndexMap indexMap;
    private LabelSchemaDescriptor schema3_4 = SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4});
    private LabelSchemaDescriptor schema5_6_7 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{6, 7});
    private LabelSchemaDescriptor schema5_8 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{8});
    private SchemaDescriptor node35_8 = SchemaDescriptorFactory.multiToken((int[])new int[]{3, 5}, (EntityType)EntityType.NODE, (int[])new int[]{8});
    private SchemaDescriptor rel35_8 = SchemaDescriptorFactory.multiToken((int[])new int[]{3, 5}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{8});

    @Before
    public void setup() {
        LongObjectHashMap map = new LongObjectHashMap();
        map.put(1L, (Object)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema3_4).withId(1L).withoutCapabilities()));
        map.put(2L, (Object)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema5_6_7).withId(2L).withoutCapabilities()));
        map.put(3L, (Object)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema5_8).withId(3L).withoutCapabilities()));
        map.put(4L, (Object)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.node35_8).withId(4L).withoutCapabilities()));
        map.put(5L, (Object)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.rel35_8).withId(5L).withoutCapabilities()));
        this.indexMap = new IndexMap((MutableLongObjectMap)map);
    }

    @Test
    public void shouldGetRelatedIndexForLabel() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
    }

    @Test
    public void shouldGetRelatedIndexForProperty() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noEntityToken, this.entityTokens(3L, 4L, 5L), this.properties(4), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4}));
    }

    @Test
    public void shouldGetRelatedIndexesForLabel() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(5L), this.entityTokens(3L, 4L), (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_6_7, this.schema5_8, this.node35_8}));
    }

    @Test
    public void shouldGetRelatedIndexes() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), this.entityTokens(4L, 5L), this.properties(7), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.schema5_6_7, this.node35_8}));
    }

    @Test
    public void shouldGetRelatedIndexOnce() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(4), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noEntityToken, this.entityTokens(5L), this.properties(6, 7), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_6_7}));
    }

    @Test
    public void shouldHandleUnrelated() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noEntityToken, noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.emptyIterableOf(SchemaDescriptor.class));
        Assert.assertTrue((boolean)this.indexMap.getRelatedIndexes(this.entityTokens(2L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE).isEmpty());
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noEntityToken, this.entityTokens(2L), this.properties(1), EntityType.NODE), (Matcher)Matchers.emptyIterableOf(SchemaDescriptor.class));
        Assert.assertTrue((boolean)this.indexMap.getRelatedIndexes(this.entityTokens(2L), this.entityTokens(2L), this.properties(1), EntityType.NODE).isEmpty());
    }

    @Test
    public void shouldGetMultiLabelForAnyOfTheLabels() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(5L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_8, this.schema5_6_7, this.node35_8}));
    }

    @Test
    public void shouldOnlyGetRelIndexesForRelUpdates() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(5L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
    }

    @Test
    public void removalsShouldOnlyRemoveCorrectProxy() {
        this.indexMap.removeIndexProxy(4L);
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(3L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
        this.indexMap.removeIndexProxy(7L);
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(5L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_8, this.schema5_6_7}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.entityTokens(5L), noEntityToken, (IntSet)IntSets.immutable.empty(), EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
    }

    private long[] entityTokens(long ... entityTokenIds) {
        return entityTokenIds;
    }

    private IntSet properties(int ... propertyIds) {
        return new IntHashSet(propertyIds);
    }

    private class TestIndexProxy
    extends IndexProxyAdapter {
        private final CapableIndexDescriptor descriptor;

        private TestIndexProxy(CapableIndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public CapableIndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

