/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.DirectIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexingServiceTest {
    @Rule
    public final LifeRule life = new LifeRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public VerboseTimeout timeoutThreadDumpRule = VerboseTimeout.builder().build();
    private static final AssertableLogProvider.LogMatcherBuilder logMatch = AssertableLogProvider.inLog(IndexingService.class);
    private static final IndexProviderDescriptor lucene10Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.LUCENE10.providerKey(), GraphDatabaseSettings.SchemaIndex.LUCENE10.providerVersion());
    private static final IndexProviderDescriptor native10Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE10.providerVersion());
    private static final IndexProviderDescriptor native20Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE20.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE20.providerVersion());
    private static final IndexProviderDescriptor nativeBtree10Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    private static final IndexProviderDescriptor fulltextDescriptor = new IndexProviderDescriptor("fulltext", "1.0");
    private final SchemaState schemaState = (SchemaState)Mockito.mock(SchemaState.class);
    private final int labelId = 7;
    private final int propertyKeyId = 15;
    private final int uniquePropertyKeyId = 15;
    private final IndexDescriptor index = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)7, (int[])new int[]{15}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
    private final IndexDescriptor uniqueIndex = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)7, (int[])new int[]{15}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
    private final IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class, (Answer)Mockito.RETURNS_MOCKS);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final TokenNameLookup nameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();

    @Before
    public void setUp() {
        Mockito.when((Object)this.populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenAnswer(invocation -> invocation.getArgument(1));
    }

    @Test
    public void noMessagesWhenThereIsNoIndexes() {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.start();
        this.internalLogProvider.assertNoLoggingOccurred();
    }

    @Test
    public void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new StoreIndexDescriptor[]{this.index.withId(0L)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        this.waitForIndexesToComeOnline(indexingService, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE_IDEMPOTENT);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new StoreIndexDescriptor[]{this.index.withId(0L)});
        indexingService.createIndexes(new StoreIndexDescriptor[]{this.index.withId(0L)});
        this.waitForIndexesToComeOnline(indexingService, 0L);
    }

    @Test
    public void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater((NodePropertyAccessor)this.storeView)).thenReturn((Object)this.updater);
        final CountDownLatch populationLatch = new CountDownLatch(1);
        final Barrier.Control populationStartBarrier = new Barrier.Control();
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                populationStartBarrier.reached();
            }

            public void indexPopulationScanComplete() {
                try {
                    populationLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Index population monitor was interrupted", e);
                }
            }
        };
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(1L, "value1")), (IndexingService.Monitor)monitor, new StoreIndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new StoreIndexDescriptor[]{this.index.withId(0L)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        populationStartBarrier.await();
        populationStartBarrier.release();
        IndexEntryUpdate<SchemaDescriptor> value2 = this.add(2L, "value2");
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(value2);
        }
        populationLatch.countDown();
        this.waitForIndexesToComeOnline(indexingService, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).close(true);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).includeSample(this.add(1L, "value1"));
        ((IndexPopulator)order.verify((Object)this.populator, Mockito.times((int)3))).add((Collection)ArgumentMatchers.any(Collection.class));
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((NodePropertyAccessor)this.storeView);
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).sampleResult();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    public void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new StoreIndexDescriptor[]{IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)20000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new StoreIndexDescriptor[]{IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        indexingService.activateIndex(0L);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
    }

    @Test
    public void shouldLogIndexStateOnInit() throws Exception {
        IndexProvider provider = this.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider), config));
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        StoreIndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)mockLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState));
        Mockito.when((Object)provider.getInitialState(onlineIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        this.life.init();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.debug("IndexingService.init: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.debug("IndexingService.init: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.debug("IndexingService.init: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    public void shouldLogIndexStateOnStart() throws Exception {
        IndexProvider provider = this.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider), config);
        providerMap.init();
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        StoreIndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState);
        Mockito.when((Object)provider.getInitialState(onlineIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.init();
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.internalLogProvider.clear();
        indexingService.start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulationFailure(failedIndex);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.debug("IndexingService.start: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.debug("IndexingService.start: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.debug("IndexingService.start: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    public void shouldNotLogWhenNoDeprecatedIndexesOnInit() throws IOException {
        StoreIndexDescriptor nativeBtree10Index = IndexingServiceTest.storeIndex(5L, 1, 5, nativeBtree10Descriptor);
        StoreIndexDescriptor fulltextIndex = IndexingServiceTest.storeIndex(6L, 1, 6, fulltextDescriptor);
        IndexProvider lucene10Provider = this.mockIndexProviderWithAccessor(lucene10Descriptor);
        IndexProvider native10Provider = this.mockIndexProviderWithAccessor(native10Descriptor);
        IndexProvider native20Provider = this.mockIndexProviderWithAccessor(native20Descriptor);
        IndexProvider nativeBtree10Provider = this.mockIndexProviderWithAccessor(nativeBtree10Descriptor);
        IndexProvider fulltextProvider = this.mockIndexProviderWithAccessor(fulltextDescriptor);
        Mockito.when((Object)nativeBtree10Provider.getInitialState(nativeBtree10Index)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)fulltextProvider.getInitialState(fulltextIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)nativeBtree10Descriptor.name());
        DependencyResolver dependencies = IndexingServiceTest.buildIndexDependencies(lucene10Provider, native10Provider, native20Provider, nativeBtree10Provider);
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(dependencies, config);
        providerMap.init();
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, Collections.singletonList(nativeBtree10Index), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState);
        indexingService.init();
        this.onBothLogProviders(logProvider -> logProvider.assertNoMessagesContaining("IndexingService.init: Deprecated index providers in use:"));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(nativeBtree10Descriptor.name()));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(fulltextDescriptor.name()));
    }

    @Test
    public void shouldNotLogWhenNoDeprecatedIndexesOnStart() throws IOException {
        StoreIndexDescriptor nativeBtree10Index = IndexingServiceTest.storeIndex(5L, 1, 5, nativeBtree10Descriptor);
        StoreIndexDescriptor fulltextIndex = IndexingServiceTest.storeIndex(6L, 1, 6, fulltextDescriptor);
        IndexProvider lucene10Provider = this.mockIndexProviderWithAccessor(lucene10Descriptor);
        IndexProvider native10Provider = this.mockIndexProviderWithAccessor(native10Descriptor);
        IndexProvider native20Provider = this.mockIndexProviderWithAccessor(native20Descriptor);
        IndexProvider nativeBtree10Provider = this.mockIndexProviderWithAccessor(nativeBtree10Descriptor);
        IndexProvider fulltextProvider = this.mockIndexProviderWithAccessor(fulltextDescriptor);
        Mockito.when((Object)nativeBtree10Provider.getInitialState(nativeBtree10Index)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)fulltextProvider.getInitialState(fulltextIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)nativeBtree10Descriptor.name());
        DependencyResolver dependencies = IndexingServiceTest.buildIndexDependencies(lucene10Provider, native10Provider, native20Provider, nativeBtree10Provider, fulltextProvider);
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(dependencies, config);
        providerMap.init();
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, Collections.singletonList(nativeBtree10Index), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState);
        indexingService.init();
        this.internalLogProvider.clear();
        indexingService.start();
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining("IndexingService.start: Deprecated index providers in use:"));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(nativeBtree10Descriptor.name()));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(fulltextDescriptor.name()));
    }

    @Test
    public void shouldLogDeprecatedIndexesOnStart() throws IOException {
        StoreIndexDescriptor lucene10Index = IndexingServiceTest.storeIndex(1L, 1, 1, lucene10Descriptor);
        StoreIndexDescriptor native10Index = IndexingServiceTest.storeIndex(2L, 1, 2, native10Descriptor);
        StoreIndexDescriptor native20Index1 = IndexingServiceTest.storeIndex(3L, 1, 3, native20Descriptor);
        StoreIndexDescriptor native20Index2 = IndexingServiceTest.storeIndex(4L, 1, 4, native20Descriptor);
        StoreIndexDescriptor nativeBtree10Index = IndexingServiceTest.storeIndex(5L, 1, 5, nativeBtree10Descriptor);
        StoreIndexDescriptor fulltextIndex = IndexingServiceTest.storeIndex(6L, 1, 6, fulltextDescriptor);
        IndexProvider lucene10Provider = this.mockIndexProviderWithAccessor(lucene10Descriptor);
        IndexProvider native10Provider = this.mockIndexProviderWithAccessor(native10Descriptor);
        IndexProvider native20Provider = this.mockIndexProviderWithAccessor(native20Descriptor);
        IndexProvider nativeBtree10Provider = this.mockIndexProviderWithAccessor(nativeBtree10Descriptor);
        IndexProvider fulltextProvider = this.mockIndexProviderWithAccessor(fulltextDescriptor);
        Mockito.when((Object)lucene10Provider.getInitialState(lucene10Index)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)native10Provider.getInitialState(native10Index)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)native20Provider.getInitialState(native20Index1)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)native20Provider.getInitialState(native20Index2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)nativeBtree10Provider.getInitialState(nativeBtree10Index)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)fulltextProvider.getInitialState(fulltextIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)nativeBtree10Descriptor.name());
        DependencyResolver dependencies = IndexingServiceTest.buildIndexDependencies(lucene10Provider, native10Provider, native20Provider, nativeBtree10Provider);
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(dependencies, config);
        providerMap.init();
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, Arrays.asList(lucene10Index, native10Index, native20Index1, native20Index2, nativeBtree10Index), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState);
        indexingService.init();
        this.userLogProvider.clear();
        indexingService.start();
        this.userLogProvider.assertContainsExactlyOneMessageMatching(Matchers.allOf((Matcher)Matchers.containsString((String)"Deprecated index providers in use:"), (Matcher)Matchers.containsString((String)(lucene10Descriptor.name() + " (1 index)")), (Matcher)Matchers.containsString((String)(native10Descriptor.name() + " (1 index)")), (Matcher)Matchers.containsString((String)(native20Descriptor.name() + " (2 indexes)")), (Matcher)Matchers.containsString((String)"Use procedure 'db.indexes()' to see what indexes use which index provider.")));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(nativeBtree10Descriptor.name()));
        this.onBothLogProviders(logProvider -> this.internalLogProvider.assertNoMessagesContaining(fulltextDescriptor.name()));
        this.userLogProvider.print(System.out);
    }

    @Test
    public void shouldFailToStartIfMissingIndexProvider() throws Exception {
        String otherProviderKey = "something-completely-different";
        IndexProviderDescriptor otherDescriptor = new IndexProviderDescriptor(otherProviderKey, "no-version");
        StoreIndexDescriptor rule = IndexingServiceTest.storeIndex(1L, 2, 3, otherDescriptor);
        this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(), rule);
        try {
            this.life.init();
            Assert.fail((String)"initIndexes with mismatching index provider should fail");
        }
        catch (LifecycleException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name()));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)otherProviderKey));
        }
    }

    @Test
    public void shouldSnapshotOnlineIndexes() throws Exception {
        int indexId = 1;
        int indexId2 = 2;
        StoreIndexDescriptor rule1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor rule2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(), rule1, rule2);
        File theFile = new File("Blah");
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState(rule1)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState(rule2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object[])new File[]{theFile, theFile}))));
    }

    @Test
    public void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        int indexId = 1;
        int indexId2 = 2;
        StoreIndexDescriptor rule1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor rule2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(), rule1, rule2);
        File theFile = new File("Blah");
        ((IndexPopulator)Mockito.doAnswer(IndexingServiceTest.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState(rule1)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState(rule2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        populatorLatch.countDown();
        this.waitForIndexesToComeOnline(indexing, indexId, indexId2);
        Assert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)theFile))));
    }

    @Test
    public void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        indexingService.activateIndex(0L);
    }

    @Test
    public void shouldLogTriggerSamplingOnAllIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        indexingService.triggerIndexSampling(mode);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling all indexes [" + mode + "]")});
    }

    @Test
    public void shouldLogTriggerSamplingOnAnIndexes() throws Exception {
        long indexId = 0L;
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        IndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), descriptor.withId(indexId));
        this.life.init();
        this.life.start();
        indexingService.triggerIndexSampling(descriptor.schema(), mode);
        String userDescription = descriptor.schema().userDescription(this.nameLookup);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling index " + userDescription + " [" + mode + "]")});
    }

    @Test
    public void applicationOfIndexUpdatesShouldThrowIfServiceIsShutdown() throws IOException, IndexEntryConflictException {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        this.life.shutdown();
        try {
            indexingService.apply(this.updates(Iterators.asSet((Object[])new IndexEntryUpdate[]{this.add(1L, "foo")})));
            Assert.fail((String)("Should have thrown " + IllegalStateException.class.getSimpleName()));
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Can't apply index updates"));
        }
    }

    private IndexUpdates updates(Iterable<IndexEntryUpdate<SchemaDescriptor>> updates) {
        return new DirectIndexUpdates(updates);
    }

    @Test
    public void applicationOfUpdatesShouldFlush() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        this.life.start();
        indexing.createIndexes(new StoreIndexDescriptor[]{this.index.withId(0L)});
        this.waitForIndexesToComeOnline(indexing, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(true);
        indexing.apply(this.updates(Arrays.asList(this.add(1L, "foo"), this.add(2L, "bar"))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.updater});
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(1L, "foo"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(2L, "bar"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void closingOfValidatedUpdatesShouldCloseUpdaters() throws Exception {
        long indexId1 = 1L;
        long indexId2 = 2L;
        int labelId1 = 24;
        int labelId2 = 42;
        StoreIndexDescriptor index1 = IndexingServiceTest.storeIndex(indexId1, labelId1, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor index2 = IndexingServiceTest.storeIndex(indexId2, labelId2, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        IndexAccessor accessor1 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor1.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater1);
        IndexAccessor accessor2 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor2.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater2);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.eq((Object)index1), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor1);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.eq((Object)index2), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor2);
        this.life.start();
        indexing.createIndexes(new StoreIndexDescriptor[]{index1});
        indexing.createIndexes(new StoreIndexDescriptor[]{index2});
        this.waitForIndexesToComeOnline(indexing, indexId1, indexId2);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(true);
        indexing.apply(this.updates(Arrays.asList(this.add(1L, "foo", labelId1), this.add(2L, "bar", labelId2))));
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
    }

    private void waitForIndexesToComeOnline(IndexingService indexing, long ... indexRuleIds) throws IndexNotFoundKernelException {
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.ONLINE, indexRuleIds);
    }

    private void waitForIndexesToGetIntoState(IndexingService indexing, InternalIndexState state, long ... indexRuleIds) throws IndexNotFoundKernelException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (!this.allInState(indexing, state, indexRuleIds)) {
            if (System.currentTimeMillis() <= end) continue;
            Assert.fail((String)"Indexes couldn't come online");
        }
    }

    private boolean allInState(IndexingService indexing, InternalIndexState state, long[] indexRuleIds) throws IndexNotFoundKernelException {
        for (long indexRuleId : indexRuleIds) {
            if (indexing.getIndexProxy(indexRuleId).getState() == state) continue;
            return false;
        }
        return true;
    }

    private IndexUpdates nodeIdsAsIndexUpdates(final long ... nodeIds) {
        return new IndexUpdates(){

            public Iterator<IndexEntryUpdate<SchemaDescriptor>> iterator() {
                ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>();
                for (long nodeId : nodeIds) {
                    updates.add(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)IndexingServiceTest.this.index.schema(), (Value[])new Value[]{Values.of((Object)1)}));
                }
                return updates.iterator();
            }

            public void feed(LongObjectMap<List<Command.PropertyCommand>> propCommandsByNodeId, LongObjectMap<List<Command.PropertyCommand>> propCommandsByRelationshipId, LongObjectMap<Command.NodeCommand> nodeCommands, LongObjectMap<Command.RelationshipCommand> relationshipCommands) {
                throw new UnsupportedOperationException();
            }

            public boolean hasUpdates() {
                return nodeIds.length > 0;
            }
        };
    }

    @Test
    public void shouldNotLoseIndexDescriptorDueToOtherSimilarIndexDuringRecovery() throws Exception {
        long nodeId = 0L;
        long indexId = 1L;
        long otherIndexId = 2L;
        EntityUpdates update = this.addNodeUpdate(nodeId, "value");
        Mockito.when((Object)this.storeView.nodeAsUpdates(ArgumentMatchers.eq((long)nodeId))).thenReturn((Object)update);
        Register.DoubleLongRegister register = (Register.DoubleLongRegister)Mockito.mock(Register.DoubleLongRegister.class);
        Mockito.when((Object)register.readSecond()).thenReturn((Object)42L);
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)register);
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)((Object)new TrackingIndexAccessor()));
        StoreIndexDescriptor storeIndex = this.index.withId(indexId);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, IndexingServiceTest.withData(update), storeIndex);
        Mockito.when((Object)this.indexProvider.getInitialState(storeIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        StoreIndexDescriptor otherIndex = storeIndex.withId(otherIndexId);
        indexing.createIndexes(new StoreIndexDescriptor[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.createIndexes(new StoreIndexDescriptor[]{storeIndex});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        indexing.apply(this.nodeIdsAsIndexUpdates(nodeId));
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor)).newUpdater(IndexUpdateMode.RECOVERY);
    }

    @Test
    public void shouldWaitForRecoveredUniquenessConstraintIndexesToBeFullyPopulated() throws Exception {
        final DoubleLatch latch = new DoubleLatch();
        ControlledIndexPopulator populator = new ControlledIndexPopulator(latch);
        final AtomicLong indexId = new AtomicLong(-1L);
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor descriptor) {
                indexId.set(descriptor.getId());
                latch.startAndWaitForAllToStart();
            }
        };
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), (IndexingService.Monitor)monitor, new StoreIndexDescriptor[0]);
        this.life.init();
        long fakeOwningConstraintRuleId = 1L;
        indexing.createIndexes(new StoreIndexDescriptor[]{IndexingServiceTest.constraintIndexRule(2L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, fakeOwningConstraintRuleId)});
        this.life.start();
        Assert.assertEquals((long)2L, (long)indexId.get());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexing.getIndexProxy(indexId.get()).getState());
    }

    @Test
    public void shouldCreateMultipleIndexesInOneCall() throws Exception {
        IndexingService.Monitor monitor = IndexingService.NO_MONITOR;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), monitor, new StoreIndexDescriptor[0]);
        this.life.start();
        StoreIndexDescriptor indexRule1 = IndexingServiceTest.storeIndex(0L, 0, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor indexRule2 = IndexingServiceTest.storeIndex(1L, 0, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        StoreIndexDescriptor indexRule3 = IndexingServiceTest.storeIndex(2L, 1, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexing.createIndexes(new StoreIndexDescriptor[]{indexRule1, indexRule2, indexRule3});
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((StoreIndexDescriptor)ArgumentMatchers.eq((Object)IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(0L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((StoreIndexDescriptor)ArgumentMatchers.eq((Object)IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(1L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((StoreIndexDescriptor)ArgumentMatchers.eq((Object)IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{0}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(2L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class));
        this.waitForIndexesToComeOnline(indexing, 0L, 1L, 2L);
    }

    @Test
    public void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterPopulating() throws Exception {
        long indexId = 1L;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new StoreIndexDescriptor[0]);
        IOException exception = new IOException("Expected failure");
        Mockito.when((Object)this.nameLookup.labelGetName(7)).thenReturn((Object)"TheLabel");
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(15)).thenReturn((Object)"propertyKey");
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        indexing.createIndexes(new StoreIndexDescriptor[]{this.index.withId(indexId)});
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, indexId);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(1L).getState());
        Assert.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        Assert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.internalLogProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    @Test
    public void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterRecoveringPopulatingIndex() throws Exception {
        long indexId = 1L;
        StoreIndexDescriptor indexRule = this.index.withId(indexId);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), indexRule);
        IOException exception = new IOException("Expected failure");
        Mockito.when((Object)this.nameLookup.labelGetName(7)).thenReturn((Object)"TheLabel");
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(15)).thenReturn((Object)"propertyKey");
        Mockito.when((Object)this.indexProvider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, indexId);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(1L).getState());
        Assert.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        Assert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.internalLogProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void shouldReportCauseOfPopulationFailureIfPopulationFailsDuringRecovery() throws IOException, IndexNotFoundKernelException, InterruptedException {
        long indexId = 1L;
        StoreIndexDescriptor indexRule = this.uniqueIndex.withId(indexId);
        final Barrier.Control barrier = new Barrier.Control();
        CountDownLatch exceptionBarrier = new CountDownLatch(1);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), (IndexingService.Monitor)new IndexingService.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor descriptor) {
                barrier.reached();
            }
        }, indexRule);
        Mockito.when((Object)this.indexProvider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.POPULATING);
        this.life.init();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            AtomicReference startException = new AtomicReference();
            executor.submit(() -> {
                try {
                    this.life.start();
                }
                catch (Throwable t) {
                    startException.set(t);
                    exceptionBarrier.countDown();
                }
            });
            barrier.await();
            IndexProxy indexProxy = indexing.getIndexProxy(indexRule.schema());
            Assert.assertThat((Object)indexProxy, (Matcher)Matchers.instanceOf(ContractCheckingIndexProxy.class));
            ContractCheckingIndexProxy contractCheckingIndexProxy = (ContractCheckingIndexProxy)indexProxy;
            IndexProxy delegate = contractCheckingIndexProxy.getDelegate();
            Assert.assertThat((Object)delegate, (Matcher)Matchers.instanceOf(FlippableIndexProxy.class));
            FlippableIndexProxy flippableIndexProxy = (FlippableIndexProxy)delegate;
            Exception expectedCause = new Exception("index was failed on purpose");
            IndexPopulationFailure indexFailure = IndexPopulationFailure.failure((Throwable)expectedCause);
            flippableIndexProxy.flipTo((IndexProxy)new FailedIndexProxy((CapableIndexDescriptor)Mockito.mock(CapableIndexDescriptor.class), "string", (IndexPopulator)Mockito.mock(IndexPopulator.class), indexFailure, (IndexCountsRemover)Mockito.mock(IndexCountsRemover.class), (LogProvider)this.internalLogProvider));
            barrier.release();
            exceptionBarrier.await();
            Throwable actual = (Throwable)startException.get();
            Assert.assertThat((Object)actual.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
            Assert.assertThat((Object)Exceptions.stringify((Throwable)actual.getCause()), (Matcher)Matchers.containsString((String)Exceptions.stringify((Throwable)expectedCause)));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void shouldLogIndexStateOutliersOnInit() throws Exception {
        int i;
        IndexProvider provider = this.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider), config));
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        ArrayList<StoreIndexDescriptor> indexes = new ArrayList<StoreIndexDescriptor>();
        int nextIndexId = 1;
        StoreIndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        StoreIndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            StoreIndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            Mockito.when((Object)mockLookup.labelGetName(i)).thenReturn((Object)("Label" + i));
        }
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)mockLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState));
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"prop");
        this.life.init();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.init: index 1 on :Label1(prop) is POPULATING"), logMatch.info("IndexingService.init: index 2 on :Label2(prop) is FAILED"), logMatch.info("IndexingService.init: indexes not specifically mentioned above are ONLINE")});
        this.internalLogProvider.assertNone(logMatch.info("IndexingService.init: index 3 on :Label3(prop) is ONLINE"));
    }

    @Test
    public void shouldLogIndexStateOutliersOnStart() throws Exception {
        int i;
        IndexProvider provider = this.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider), config);
        providerMap.init();
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        ArrayList<StoreIndexDescriptor> indexes = new ArrayList<StoreIndexDescriptor>();
        int nextIndexId = 1;
        StoreIndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        StoreIndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            StoreIndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            Mockito.when((Object)mockLookup.labelGetName(i)).thenReturn((Object)("Label" + i));
        }
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState);
        Mockito.when((Object)this.storeView.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"prop");
        indexingService.init();
        this.internalLogProvider.clear();
        indexingService.start();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.start: index 1 on :Label1(prop) is POPULATING"), logMatch.info("IndexingService.start: index 2 on :Label2(prop) is FAILED"), logMatch.info("IndexingService.start: indexes not specifically mentioned above are ONLINE")});
        this.internalLogProvider.assertNone(logMatch.info("IndexingService.start: index 3 on :Label3(prop) is ONLINE"));
    }

    @Test
    public void flushAllIndexesWhileSomeOfThemDropped() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy validIndex1 = IndexingServiceTest.createIndexProxyMock(1L);
        IndexProxy validIndex2 = IndexingServiceTest.createIndexProxyMock(2L);
        IndexProxy deletedIndexProxy = IndexingServiceTest.createIndexProxyMock(3L);
        IndexProxy validIndex3 = IndexingServiceTest.createIndexProxyMock(4L);
        IndexProxy validIndex4 = IndexingServiceTest.createIndexProxyMock(5L);
        indexMapReference.modify(indexMap -> {
            indexMap.putIndexProxy(validIndex1);
            indexMap.putIndexProxy(validIndex2);
            indexMap.putIndexProxy(deletedIndexProxy);
            indexMap.putIndexProxy(validIndex3);
            indexMap.putIndexProxy(validIndex4);
            return indexMap;
        });
        ((IndexProxy)Mockito.doAnswer(invocation -> {
            indexMapReference.modify(indexMap -> {
                indexMap.removeIndexProxy(3L);
                return indexMap;
            });
            throw new RuntimeException("Index deleted.");
        }).when((Object)deletedIndexProxy)).force((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.forceAll(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex1, (VerificationMode)Mockito.times((int)1))).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex2, (VerificationMode)Mockito.times((int)1))).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex3, (VerificationMode)Mockito.times((int)1))).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex4, (VerificationMode)Mockito.times((int)1))).force(IOLimiter.UNLIMITED);
    }

    @Test
    public void failForceAllWhenOneOfTheIndexesFailToForce() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy strangeIndexProxy = IndexingServiceTest.createIndexProxyMock(1L);
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(new IOException("Can't force"))}).when((Object)strangeIndexProxy)).force((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        indexMapReference.modify(indexMap -> {
            IndexProxy validIndex = IndexingServiceTest.createIndexProxyMock(0L);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(strangeIndexProxy);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            return indexMap;
        });
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        this.expectedException.expectMessage("Unable to force");
        this.expectedException.expect(UnderlyingStorageException.class);
        indexingService.forceAll(IOLimiter.UNLIMITED);
    }

    @Test
    public void shouldRefreshIndexesOnStart() throws Exception {
        StoreIndexDescriptor rule = this.index.withId(0L);
        this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), rule);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor);
        this.life.init();
        ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.never())).refresh();
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.times((int)1))).refresh();
    }

    @Test
    public void shouldForgetDeferredIndexDropDuringRecoveryIfCreatedIndexWithSameRuleId() throws Exception {
        StoreIndexDescriptor rule = this.index.withId(0L);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), rule);
        this.life.init();
        indexing.dropIndex(rule);
        indexing.createIndexes(new StoreIndexDescriptor[]{rule});
        this.life.start();
        IndexProxy proxy = indexing.getIndexProxy(rule.getId());
        Assert.assertNotNull((Object)proxy);
        ((IndexAccessor)Mockito.verify((Object)this.accessor, (VerificationMode)Mockito.never())).drop();
    }

    private static IndexProxy createIndexProxyMock(long indexId) {
        IndexProxy proxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        CapableIndexDescriptor descriptor = IndexingServiceTest.storeIndex(indexId, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withoutCapabilities();
        Mockito.when((Object)proxy.getDescriptor()).thenReturn((Object)descriptor);
        return proxy;
    }

    private static Matcher<? extends Throwable> causedBy(final Throwable exception) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                while (item != null) {
                    if (item == exception) {
                        return true;
                    }
                    item = item.getCause();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("exception caused by ").appendValue((Object)exception);
            }
        };
    }

    private String storedFailure() {
        ArgumentCaptor reason = ArgumentCaptor.forClass(String.class);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed((String)reason.capture());
        return (String)reason.getValue();
    }

    private static Answer<Void> waitForLatch(CountDownLatch latch) {
        return invocationOnMock -> {
            latch.await();
            return null;
        };
    }

    private static Answer<ResourceIterator<File>> newResourceIterator(File theFile) {
        return invocationOnMock -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)theFile));
    }

    private EntityUpdates addNodeUpdate(long nodeId, Object propertyValue) {
        return this.addNodeUpdate(nodeId, propertyValue, 7);
    }

    private EntityUpdates addNodeUpdate(long nodeId, Object propertyValue, int labelId) {
        return EntityUpdates.forEntity((long)nodeId).withTokens(new long[]{labelId}).added(this.index.schema().getPropertyId(), Values.of((Object)propertyValue)).build();
    }

    private IndexEntryUpdate<SchemaDescriptor> add(long nodeId, Object propertyValue) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.index.schema(), (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private IndexEntryUpdate<SchemaDescriptor> add(long nodeId, Object propertyValue, int labelId) {
        LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{this.index.schema().getPropertyId()});
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, StoreIndexDescriptor ... rules) throws IOException {
        return this.newIndexingServiceWithMockedDependencies(populator, accessor, data, IndexingService.NO_MONITOR, rules);
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexingService.Monitor monitor, StoreIndexDescriptor ... rules) throws IOException {
        Mockito.when((Object)this.indexProvider.getInitialState((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class))).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.nameLookup.labelGetName(ArgumentMatchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("label"));
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(ArgumentMatchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("property"));
        Config config = Config.defaults((Setting)GraphDatabaseSettings.multi_threaded_schema_index_population_enabled, (String)"false");
        config.augment(GraphDatabaseSettings.default_schema_provider, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        DefaultIndexProviderMap providerMap = (DefaultIndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(this.indexProvider), config));
        return (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)this.life.add((Lifecycle)JobSchedulerFactory.createScheduler())), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, (Iterable)Iterators.loop((Iterator)Iterators.iterator((Object[])rules)), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)monitor, (SchemaState)this.schemaState));
    }

    private static DataUpdates withData(EntityUpdates ... updates) {
        return new DataUpdates(updates);
    }

    private static StoreIndexDescriptor storeIndex(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}), (IndexProviderDescriptor)providerDescriptor).withId(ruleId);
    }

    private static StoreIndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}), (IndexProviderDescriptor)providerDescriptor).withId(ruleId);
    }

    private static StoreIndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor, long constraintId) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}), (IndexProviderDescriptor)providerDescriptor).withIds(ruleId, constraintId);
    }

    private IndexingService createIndexServiceWithCustomIndexMap(IndexMapReference indexMapReference) {
        return new IndexingService((IndexProxyCreator)Mockito.mock(IndexProxyCreator.class), (IndexProviderMap)Mockito.mock(IndexProviderMap.class), indexMapReference, (IndexStoreView)Mockito.mock(IndexStoreView.class), Collections.emptyList(), (IndexSamplingController)Mockito.mock(IndexSamplingController.class), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), (JobScheduler)Mockito.mock(JobScheduler.class), (SchemaState)Mockito.mock(SchemaState.class), (MultiPopulatorFactory)Mockito.mock(MultiPopulatorFactory.class), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, IndexingService.NO_MONITOR);
    }

    private static DependencyResolver buildIndexDependencies(IndexProvider provider) {
        return IndexingServiceTest.buildIndexDependencies(new IndexProvider[]{provider});
    }

    private static DependencyResolver buildIndexDependencies(IndexProvider ... providers) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies((Object[])providers);
        return dependencies;
    }

    private IndexProvider mockIndexProviderWithAccessor(IndexProviderDescriptor descriptor) throws IOException {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)descriptor);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getOnlineAccessor((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)indexAccessor);
        return provider;
    }

    private void onBothLogProviders(Consumer<AssertableLogProvider> logProviderAction) {
        logProviderAction.accept(this.internalLogProvider);
        logProviderAction.accept(this.userLogProvider);
    }

    private static class TrackingIndexAccessor
    extends IndexAccessor.Adapter {
        private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);

        private TrackingIndexAccessor() {
        }

        public void drop() {
            throw new UnsupportedOperationException("Not required");
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.updater;
        }

        public IndexReader newReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public ResourceIterator<File> snapshotFiles() {
            throw new UnsupportedOperationException("Not required");
        }
    }

    private static class NameLookupAnswer
    implements Answer<String> {
        private final String kind;

        NameLookupAnswer(String kind) {
            this.kind = kind;
        }

        public String answer(InvocationOnMock invocation) {
            int id = (Integer)invocation.getArgument(0);
            return this.kind + "[" + id + "]";
        }
    }

    private static class DataUpdates
    implements Answer<StoreScan<IndexPopulationFailedKernelException>> {
        private final EntityUpdates[] updates;

        DataUpdates() {
            this.updates = new EntityUpdates[0];
        }

        DataUpdates(EntityUpdates[] updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(Visitor.class), (Visitor)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean())).thenAnswer((Answer)this);
        }

        public StoreScan<IndexPopulationFailedKernelException> answer(InvocationOnMock invocation) {
            final Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor = DataUpdates.visitor(invocation.getArgument(2));
            return new StoreScan<IndexPopulationFailedKernelException>(){
                private volatile boolean stop;

                public void run() throws IndexPopulationFailedKernelException {
                    for (EntityUpdates update : updates) {
                        if (this.stop) {
                            return;
                        }
                        visitor.visit((Object)update);
                    }
                }

                public void stop() {
                    this.stop = true;
                }

                public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
                }

                public PopulationProgress getProgress() {
                    return new PopulationProgress(42L, 100L);
                }
            };
        }

        private static Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor(Object v) {
            return (Visitor)v;
        }

        public String toString() {
            return Arrays.toString(this.updates);
        }
    }

    private static class ControlledIndexPopulator
    extends IndexPopulator.Adapter {
        private final DoubleLatch latch;

        ControlledIndexPopulator(DoubleLatch latch) {
            this.latch = latch;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.latch.waitForAllToStart();
        }

        public void close(boolean populationCompletedSuccessfully) {
            this.latch.finish();
        }
    }
}

