/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.time.Clock;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.LoggingPhaseTracker;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.time.FakeClock;

public class LoggingPhaseTrackerTest {
    private FakeClock clock = new FakeClock();

    @Test
    public void shouldLogSingleTime() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.stop();
        EnumMap times = phaseTracker.times();
        for (PhaseTracker.Phase phase : times.keySet()) {
            LoggingPhaseTracker.Logger logger = (LoggingPhaseTracker.Logger)times.get(phase);
            if (phase == PhaseTracker.Phase.SCAN) {
                Assert.assertTrue((logger.totalTime >= 100L ? 1 : 0) != 0);
                Assert.assertTrue((logger.totalTime < 500L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)0L, (long)logger.totalTime);
        }
    }

    @Test
    public void shouldLogMultipleTimes() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.sleep(100);
        phaseTracker.stop();
        EnumMap times = phaseTracker.times();
        for (PhaseTracker.Phase phase : times.keySet()) {
            LoggingPhaseTracker.Logger logger = (LoggingPhaseTracker.Logger)times.get(phase);
            if (phase == PhaseTracker.Phase.SCAN || phase == PhaseTracker.Phase.WRITE) {
                Assert.assertTrue((logger.totalTime >= 100L ? 1 : 0) != 0);
                Assert.assertTrue((logger.totalTime < 500L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)0L, (long)logger.totalTime);
        }
    }

    @Test
    public void shouldAccumulateTimes() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        LoggingPhaseTracker.Logger scanLogger = (LoggingPhaseTracker.Logger)phaseTracker.times().get(PhaseTracker.Phase.SCAN);
        long firstCount = scanLogger.totalTime;
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.stop();
        Assert.assertTrue((scanLogger.totalTime > firstCount ? 1 : 0) != 0);
    }

    @Test
    public void throwIfEnterAfterStop() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.stop();
        try {
            phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Trying to report a new phase after phase tracker has been stopped."));
        }
    }

    @Test
    public void mustReportMain() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(IndexPopulationJob.class);
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker(log);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.FLIP);
        this.sleep(100);
        phaseTracker.stop();
        AssertableLogProvider.LogMatcher logMatcher = AssertableLogProvider.inLog(IndexPopulationJob.class).info("TIME/PHASE Final: SCAN[totalTime=100ms, avgTime=100ms, minTime=0ns, maxTime=100ms, nbrOfReports=1], WRITE[totalTime=100ms, avgTime=100ms, minTime=0ns, maxTime=100ms, nbrOfReports=1], FLIP[totalTime=100ms, avgTime=100ms, minTime=0ns, maxTime=100ms, nbrOfReports=1]");
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatcher});
    }

    @Test
    public void mustReportPeriod() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(IndexPopulationJob.class);
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker(1, log);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(1000);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        AssertableLogProvider.LogMatcher logMatcher = AssertableLogProvider.inLog(IndexPopulationJob.class).debug("TIME/PHASE Total: SCAN[totalTime=1s, avgTime=1s, minTime=0ns, maxTime=1s, nbrOfReports=1], WRITE[nbrOfReports=0], FLIP[nbrOfReports=0], Last 1 sec: SCAN[totalTime=1s, avgTime=1s, minTime=1s, maxTime=1s, nbrOfReports=1], WRITE[nbrOfReports=0], FLIP[nbrOfReports=0]");
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatcher});
    }

    private LoggingPhaseTracker getPhaseTracker() {
        return this.getPhaseTracker((Log)NullLog.getInstance());
    }

    private LoggingPhaseTracker getPhaseTracker(Log log) {
        return this.getPhaseTracker(LoggingPhaseTracker.PERIOD_INTERVAL, log);
    }

    private LoggingPhaseTracker getPhaseTracker(int periodIntervalInSeconds, Log log) {
        return new LoggingPhaseTracker((long)periodIntervalInSeconds, log, (Clock)this.clock);
    }

    private void sleep(int i) {
        this.clock.forward((long)i, TimeUnit.MILLISECONDS);
    }
}

